/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.badge;

import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.service.framework.badge.BadgeBuilder;
import com.teamscale.service.framework.badge.SegmentStyle;
import com.teamscale.service.framework.badge.sections.EBadgeIcon;
import jakarta.ws.rs.InternalServerErrorException;
import org.conqat.lib.commons.string.StringUtils;

public class FindingBadgeCreator {
    private final int addedFindings;
    private final int inChangedCodeFindings;
    private final int removedFindings;
    private final boolean showZeroFindings;
    private static final int INNER_MARGIN = 5;
    public static final int OUTER_MARGIN = 8;
    public static final int ICON_TEXT_MARGIN = 4;

    public FindingBadgeCreator(int addedFindings, int inChangedCodeFindings, int removedFindings, boolean showZeroFindings) {
        this.addedFindings = addedFindings;
        this.inChangedCodeFindings = inChangedCodeFindings;
        this.removedFindings = removedFindings;
        this.showZeroFindings = showZeroFindings;
    }

    public FindingBadgeCreator(FindingDeltaCount findingDelta, boolean showZeroFindings) {
        this(findingDelta.addedFindings(), findingDelta.findingsInChangedCode(), findingDelta.removedFindings(), showZeroFindings);
    }

    public String createBadge() throws InternalServerErrorException {
        BadgeBuilder badgeBuilder = new BadgeBuilder().textSegment("Findings").style(SegmentStyle.TITLE).append();
        if (this.areNoFindingsToDisplay()) {
            badgeBuilder.textSegment("unchanged").style(SegmentStyle.BLACK).append();
        } else {
            this.appendFindingsSegment(badgeBuilder, this.addedFindings, true, !this.showZeroFindings && this.inChangedCodeFindings == 0 && this.removedFindings == 0, EBadgeIcon.ROUND_EXCLAMATION_SIGN, SegmentStyle.RED);
            this.appendFindingsSegment(badgeBuilder, this.inChangedCodeFindings, !this.showZeroFindings && this.addedFindings == 0, !this.showZeroFindings && this.removedFindings == 0, EBadgeIcon.SQUARE_EDIT_SIGN, SegmentStyle.BLUE);
            this.appendFindingsSegment(badgeBuilder, this.removedFindings, !this.showZeroFindings && this.addedFindings == 0 && this.inChangedCodeFindings == 0, true, EBadgeIcon.SQUARE_CHECK_SIGN, SegmentStyle.GREEN);
        }
        return badgeBuilder.toSvg();
    }

    private void appendFindingsSegment(BadgeBuilder badgeBuilder, int findings, boolean isFirstSegment, boolean isLastSegment, EBadgeIcon icon, SegmentStyle style) {
        if (findings > 0 || this.showZeroFindings) {
            badgeBuilder.segment().style(style).air(isFirstSegment ? 8.0 : 5.0).icon(icon).air(4.0).text(StringUtils.format((Number)findings)).air(isLastSegment ? 8.0 : 5.0).append();
        }
    }

    private boolean areNoFindingsToDisplay() {
        return !this.showZeroFindings && this.addedFindings == 0 && this.inChangedCodeFindings == 0 && this.removedFindings == 0;
    }
}

