/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.refactoring;

import com.teamscale.service.findings.refactoring.DataflowAnalyzer;
import com.teamscale.service.findings.refactoring.Method;
import com.teamscale.service.findings.refactoring.RefactoringAnalysisException;
import com.teamscale.service.findings.refactoring.ScoreCalculator;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ExtractMethodCandidate
implements Comparable<Object> {
    private final Method method;
    private final List<ShallowEntity> shallowEntities;
    private Set<String> inputParameters;
    private Set<String> returnParameters;
    private final double score;

    public ExtractMethodCandidate(Method method, List<ShallowEntity> shallowEntities) throws RefactoringAnalysisException {
        this.method = method;
        this.shallowEntities = shallowEntities;
        this.setInputParameters();
        this.setReturnParameters();
        this.score = ScoreCalculator.getTotalScore(this, method);
    }

    public List<ShallowEntity> getShallowEntities() {
        return this.shallowEntities;
    }

    public Set<String> getInputParameters() {
        return this.inputParameters;
    }

    public double getScore() {
        return this.score;
    }

    private void setInputParameters() {
        Set<String> parameters = DataflowAnalyzer.getUsedButNotDefinedVariableIdentifiers(this.shallowEntities, this.method);
        CollectionUtils.removeAll(parameters, this.method.getGlobalVariables());
        this.inputParameters = parameters;
    }

    protected boolean isLongEnough() {
        if (this.getNumberOfStatements() < 3) {
            return false;
        }
        List remainingEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.method.getEntity().getChildrenOfType(EShallowEntityType.STATEMENT));
        remainingEntities.removeAll(ShallowEntityTraversalUtils.getAllEntities(this.shallowEntities));
        return remainingEntities.size() + 1 >= 3;
    }

    protected boolean isExtractable() {
        if (ShallowParsingUtils.containsLoopReferenceWithoutLoop(this.shallowEntities)) {
            return false;
        }
        return this.getReturnParameters().size() <= 1;
    }

    private void setReturnParameters() throws RefactoringAnalysisException {
        this.returnParameters = new HashSet<String>();
        Set<String> writesInCandidate = DataflowAnalyzer.getWritesInFragment(this.method, this.shallowEntities);
        CollectionUtils.removeAll(writesInCandidate, this.method.getGlobalVariables());
        Set<String> readsBeforeWritesAfterCandidate = DataflowAnalyzer.getReadsBeforeWritesAfterBlock(this.method, this.shallowEntities);
        CollectionUtils.removeAll(readsBeforeWritesAfterCandidate, this.method.getGlobalVariables());
        for (String write : writesInCandidate) {
            if (!readsBeforeWritesAfterCandidate.contains(write)) continue;
            this.returnParameters.add(write);
        }
        this.returnParameters.addAll(ShallowParsingUtils.getReturnParameters(this.shallowEntities));
    }

    public Set<String> getReturnParameters() {
        return this.returnParameters;
    }

    public int getStartLine() {
        return this.shallowEntities.get(0).getStartLine();
    }

    public int getEndLine() {
        return this.shallowEntities.get(this.shallowEntities.size() - 1).getEndLine();
    }

    public int getLength() {
        return this.getEndLine() - this.getStartLine() + 1;
    }

    protected int getNumberOfStatements() {
        return ShallowEntityTraversalUtils.listEntitiesOfType(this.shallowEntities, (EShallowEntityType)EShallowEntityType.STATEMENT).size();
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof ExtractMethodCandidate) {
            return Double.compare(this.getScore(), ((ExtractMethodCandidate)other).getScore());
        }
        return 0;
    }

    public Method getMethod() {
        return this.method;
    }
}

