/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.ide;

import com.google.common.collect.ImmutableList;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.ide.IAutoPrefixMappingsServiceApi;
import com.teamscale.service.ide.ProjectMapping;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/auto-prefix-mappings")
public class AutoPrefixMappingsService
extends ApiBase
implements IAutoPrefixMappingsServiceApi {
    @Override
    public List<ProjectMapping> calculateProjectMappings(String branchName, List<String> filePaths) throws StorageException {
        return AutoPrefixMappingsService.calculateProjectMappings(this.getProjectStorageSystem(), this.serviceInfo.getPrimaryPublicId(), branchName, filePaths);
    }

    public static List<ProjectMapping> calculateProjectMappings(CommitResolvingStorageSystem projectStorageSystem, PublicProjectId projectId, String branchName, List<String> filePaths) throws StorageException {
        ArrayList<ProjectMapping> projectMappings = new ArrayList<ProjectMapping>();
        PathLookupIndex lookupIndex = AutoPrefixMappingsService.openPathLookupIndex(projectStorageSystem, branchName);
        for (String file : filePaths) {
            projectMappings.addAll(AutoPrefixMappingsService.searchMappingsForProject(lookupIndex, projectId, file));
        }
        return projectMappings;
    }

    private static List<ProjectMapping> searchMappingsForProject(PathLookupIndex lookupIndex, PublicProjectId projectId, String file) throws StorageException {
        Optional paths = lookupIndex.lookupPath(file, PathLookupOptions.defaults());
        if (!paths.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<ProjectMapping> projectMappings = new ArrayList<ProjectMapping>();
        String matchedCommonSuffix = (String)((Pair)paths.get()).getFirst();
        for (String pathCandidate : (ImmutableList)((Pair)paths.get()).getSecond()) {
            String from = StringUtils.stripSuffix((String)file, (String)matchedCommonSuffix);
            String to = StringUtils.stripSuffix((String)pathCandidate, (String)matchedCommonSuffix);
            ProjectMapping mapping = new ProjectMapping(pathCandidate, projectId, from, to);
            projectMappings.add(mapping);
        }
        return projectMappings;
    }

    private static String getBranchName(CommitResolvingStorageSystem projectStorageSystem, String branchName) throws StorageException {
        if (!StringUtils.isEmpty((String)branchName)) {
            return branchName;
        }
        return ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
    }

    private static PathLookupIndex openPathLookupIndex(CommitResolvingStorageSystem projectStorageSystem, String branchName) throws StorageException {
        String branchNameOrDefault = AutoPrefixMappingsService.getBranchName(projectStorageSystem, branchName);
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHeadUnbranched();
        if (!StringUtils.isEmpty((String)branchNameOrDefault)) {
            historyAccessOption = HistoryAccessOption.readHead((String)branchNameOrDefault);
        }
        return (PathLookupIndex)projectStorageSystem.openProjectIndex(PathLookupIndex.class, historyAccessOption);
    }
}

