/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.interaction.ShortInteractionLog;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IGlobalLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/logs/interaction")
public class InteractionLogGlobalLogService
extends ApiBase
implements IGlobalLogServiceApi<ShortInteractionLog, DetailedWorkerLog> {
    static final String INTERACTION_LOG_FILENAME = "TeamscaleInteractionLogExport";

    @Override
    @Operation(summary="Get all interaction logs", description="Returns a list of all interaction short logs.", tags={"Logging"}, operationId="getGlobalInteractionLogs")
    public ShortLogResponse<ShortInteractionLog> getAllShortLogs(LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, InteractionLogGlobalLogService.openInteractionLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Get interaction detail log", description="Returns the detailed interaction log entry for the given timestamp.", tags={"Logging"}, operationId="getGlobalInteractionLog")
    public DetailedWorkerLog getDetailedLog(LogEntryIdentifier logEntryIdentifier) throws StorageException {
        throw new BadRequestException("Loading detailed entries is not implemented for interaction logs.");
    }

    @Override
    @Operation(summary="Get interaction log frequencies", description="Returns the frequencies of the various interaction log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getGlobalInteractionLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies() throws StorageException {
        return LogServiceUtils.obtainFrequencies(InteractionLogGlobalLogService.openInteractionLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Download interaction logs", description="Returns a file download of all interaction logs.", tags={"Logging"}, operationId="downloadGlobalInteractionLogs")
    public Response downloadLog(@BeanParam LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)INTERACTION_LOG_FILENAME, (LogFilteringParameters)logFilteringParameters, (int)maxChars, InteractionLogGlobalLogService.openInteractionLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Delete interaction logs", description="Deletes all log entries that match the applied filters.", tags={"Logging"}, operationId="deleteGlobalInteractionLogs")
    public void deleteLogEntries(LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, InteractionLogGlobalLogService.openInteractionLogIndexes(this.getIndexLayer()));
        AuditLogs.globalLogDeletion((String)"interaction logs");
    }

    public static LogIndexesWrapper<ShortInteractionLog, DetailedWorkerLog> openInteractionLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList allWorkerLogIndexes = LogServiceUtils.getAllInteractionLogIndexes((IndexLayer)indexLayer);
        return new LogIndexesWrapper(allWorkerLogIndexes);
    }
}

