/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.history;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.history.MetricHistoryService;
import com.teamscale.service.metrics.history.MetricHistoryServiceQueryOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;

@ReadCacheEnabled
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
@Path(value="api/projects/{project}/metrics/history/commits")
public class MetricHistoryCommitsService
extends ApiBase {
    @GET
    @Operation(summary="Get metric history commits", description="Returns the full commits (with branch name) for points in time of a metric history trend", tags={"Metrics"}, responses={@ApiResponse(responseCode="400", description="Invalid timestamp provided.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<CommitDescriptor> getMetricHistoryCommits(@BeanParam MetricHistoryServiceQueryOptions parameters, @Parameter(description="The timestamps to look up.") @QueryParam(value="timestamp") List<Long> timestamps) throws StorageException {
        CommitDescriptor endCommit = MetricHistoryService.getEndCommit(parameters, (ProjectStorageSystem)this.getProjectStorageSystem(), DateTimeUtils.millisNow());
        CommitDescriptorIndex commitDescriptorIndex = this.openCommitDescriptorIndex();
        CommitDescriptor realEnd = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(endCommit, 0L).orElse(endCommit);
        List relevantCommits = CollectionUtils.map((Collection)commitDescriptorIndex.getCommitHistoryWithFirstParentCommits(realEnd, 0L), ParentedCommitDescriptor::getCommit);
        Collections.reverse(relevantCommits);
        String defaultBranchName = this.getDefaultBranchName();
        ArrayList<CommitDescriptor> result = new ArrayList<CommitDescriptor>();
        for (long timestamp : timestamps) {
            try {
                result.add(MetricHistoryCommitsService.lookupTimestampForTrend(timestamp, relevantCommits, defaultBranchName));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Not a valid timestamp: " + timestamp);
            }
        }
        return result;
    }

    private static CommitDescriptor lookupTimestampForTrend(long timestamp, List<CommitDescriptor> commits, String defaultBranchName) {
        int index = Collections.binarySearch(commits, CommitDescriptor.createUnbranchedDescriptor((long)timestamp), Comparator.comparingLong(CommitDescriptor::getTimestamp));
        if (index >= 0) {
            return commits.get(index);
        }
        if ((index = -index - 1) == 0) {
            return new CommitDescriptor(defaultBranchName, timestamp);
        }
        String branchName = commits.get(index - 1).getBranchName();
        return new CommitDescriptor(branchName, timestamp);
    }
}

