/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.user.User;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.findings.ElementFindingsServiceBase;
import com.teamscale.service.metrics.treemap.IFindingsTreeMapServiceApi;
import com.teamscale.service.metrics.treemap.builder.FindingsTreeMapBuilder;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Path;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/findings/treemap")
public class FindingsTreeMapService
extends ElementFindingsServiceBase
implements IFindingsTreeMapServiceApi {
    private static final String AREA_METRIC = "Lines of Code";

    @Override
    public IFindingsTreeMapServiceApi.FindingsTreemapWrapper getFindingsTreemap(UniformPath uniformPath, Color mainColor, FindingsFilterSettings findingsFilterSettings) throws StorageException, TreeMapBuilderException {
        CommitDescriptor commitDescriptor = this.resolve(findingsFilterSettings.getCommit());
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commitDescriptor);
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), null, (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (boolean)true);
        MetricDirectorySchema schema = metricRetrievalStrategy.getMetricDirectorySchema(historyAccessOption.cloneToUnbranchedAccessOption());
        int valuePosition = schema.getValuePosition(AREA_METRIC);
        if (valuePosition == -1) {
            throw new BadRequestException("The area metric Lines of Code is not available in the schema.");
        }
        MetricsToArchitectureMetricsMappingIndex architectureMappingIndex = this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption);
        CodeScopesMappingIndex codeScopesMappingIndex = this.openProjectIndex(CodeScopesMappingIndex.class, historyAccessOption);
        List findings = this.retrieveFilteredFindings(uniformPath, findingsFilterSettings).filteredFindings();
        FindingsTreeMapBuilder treeMapBuilder = new FindingsTreeMapBuilder(findings, metricRetrievalStrategy, historyAccessOption, valuePosition, mainColor, architectureMappingIndex, codeScopesMappingIndex);
        IFindingsTreeMapServiceApi.FindingsTreemapWrapper treemapWrapper = new IFindingsTreeMapServiceApi.FindingsTreemapWrapper();
        treemapWrapper.treemap = treeMapBuilder.buildTreeMap(uniformPath);
        treemapWrapper.coloredAreaSize = FindingsTreeMapService.getColoredAreaSize(treemapWrapper.treemap, treemapWrapper.affectedUniformPaths);
        treemapWrapper.overallFiles = this.getOverallFiles((ITreeMapNode<MetricDirectoryEntry>)treemapWrapper.treemap);
        treemapWrapper.overallFindings = findings.size();
        return treemapWrapper;
    }

    private int getOverallFiles(ITreeMapNode<MetricDirectoryEntry> treemap) {
        if (treemap.getChildren().isEmpty()) {
            return 1;
        }
        return treemap.getChildren().stream().mapToInt(this::getOverallFiles).sum();
    }

    private static double getColoredAreaSize(TreeMapNode treemap, Set<String> uniformPaths) {
        double coloredAreaSize = 0.0;
        ArrayDeque<TreeMapNode> nodesToBeProcessed = new ArrayDeque<TreeMapNode>(Collections.singleton(treemap));
        while (!nodesToBeProcessed.isEmpty()) {
            ITreeMapNode current = (ITreeMapNode)nodesToBeProcessed.pop();
            List children = current.getChildren();
            if (CollectionUtils.isNullOrEmpty((Collection)children)) {
                if (Color.WHITE.equals(current.getColor())) continue;
                coloredAreaSize += current.getArea();
                uniformPaths.add(current.getText());
                continue;
            }
            nodesToBeProcessed.addAll(children);
        }
        return coloredAreaSize;
    }
}

