/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.awt.Color;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

public interface IFindingsTreeMapServiceApi {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get findings treemap", description="Produces a treemap of finding frequencies. The intensity of the rectangle colors determine the finding frequency in the corresponding file.", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public FindingsTreemapWrapper getFindingsTreemap(@QueryParam(value="uniform-path") @DefaultValue(value="") UniformPath var1, @QueryParam(value="color") @DefaultValue(value="blue") @Parameter(description="Optional: The main color for the treemap.") Color var2, @BeanParam FindingsFilterSettings var3) throws StorageException, TreeMapBuilderException;

    public static class FindingsTreemapWrapper {
        @JsonProperty(value="affectedUniformPaths")
        protected final Set<String> affectedUniformPaths = new TreeSet<String>();
        @JsonProperty(value="treemap")
        protected TreeMapNode treemap;
        @JsonProperty(value="coloredAreaSize")
        protected double coloredAreaSize;
        @JsonProperty(value="overallFindings")
        protected int overallFindings;
        @JsonProperty(value="overallFiles")
        protected int overallFiles;

        public UnmodifiableSet<String> getAffectedUniformPaths() {
            return UnmodifiableSet.of(this.affectedUniformPaths);
        }

        public int getOverallFindings() {
            return this.overallFindings;
        }
    }
}

