/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.abap.UsageInfo;
import com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode;
import com.teamscale.index.testgap.treemap.TreeMapNodeBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.treemap.UsageTreeMapWrapper;
import com.teamscale.service.usage.UsageServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code-usage/treemap")
public class UsageTreeMapService
extends UsageServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get code usage treemap", description="Returns a usage treemap. For each method under the selected uniform path, the treemap shows how often the method was executed in the specified time frame.", tags={"Code Usage"})
    public UsageTreeMapWrapper getCodeUsageTreemap(@BeanParam TimeIntervalBasedServiceQueryOptions intervalOptions, @Parameter(required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath pathPrefix) throws StorageException {
        UsageTreeMapService usageTreeMapService = this;
        CommitDescriptor baselineCommit = intervalOptions.resolveBaselineCommit(() -> usageTreeMapService.getProjectStorageSystem());
        UsageTreeMapService usageTreeMapService2 = this;
        CommitDescriptor endCommit = intervalOptions.resolveEndCommit(() -> usageTreeMapService2.getProjectStorageSystem());
        List<UsageInfo> usageInfos = this.createRelevantUsageInfos(pathPrefix, baselineCommit, endCommit);
        TgaMethodTreeMapNode treemap = UsageTreeMapService.createTreeMap(usageInfos);
        long maximumCount = usageInfos.stream().mapToLong(UsageInfo::getExecutionCount).max().orElse(0L);
        return new UsageTreeMapWrapper(treemap, maximumCount, UsageTreeMapService.getUnusedPercentage(usageInfos));
    }

    private static double getUnusedPercentage(List<UsageInfo> usageInfos) {
        if (usageInfos.isEmpty()) {
            return 1.0;
        }
        return (double)usageInfos.stream().filter(info -> info.getExecutionCount() == 0L).count() / (double)usageInfos.size();
    }

    private static TgaMethodTreeMapNode createTreeMap(List<UsageInfo> usageInfos) {
        return UsageTreeMapService.buildTreeMapNodes(usageInfos);
    }

    private static TgaMethodTreeMapNode buildTreeMapNodes(List<UsageInfo> usageInfos) {
        Collections.sort(usageInfos);
        TgaMethodTreeMapNode root = new TgaMethodTreeMapNode();
        for (UsageInfo entry : usageInfos) {
            TgaMethodTreeMapNode fileNode = TgaMethodTreeMapNode.findOrCreateNode((TgaMethodTreeMapNode)root, (String)entry.getUniformPath());
            TgaMethodTreeMapNode methodNode = TgaMethodTreeMapNode.createMethodNode((UsageInfo)entry);
            fileNode.addChild((TreeMapNodeBase)methodNode);
        }
        root.recalculateAreaAggregates();
        UsageTreeMapService.aggregateCounts(root);
        return root;
    }

    private static void aggregateCounts(TgaMethodTreeMapNode root) {
        if (root.getChildren().isEmpty()) {
            return;
        }
        long aggregatedCount = 0L;
        for (ITreeMapNode child : root.getChildren()) {
            TgaMethodTreeMapNode tgaChild = (TgaMethodTreeMapNode)child;
            UsageTreeMapService.aggregateCounts(tgaChild);
            aggregatedCount = Math.max(tgaChild.getCount(), aggregatedCount);
        }
        root.setCount(aggregatedCount);
    }
}

