/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit;

import com.google.common.collect.Sets;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.service.precommit.RepositoryConnectorShallowConfig;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.conqat.engine.index.shared.PreCommit3Result;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class PreCommitUploadDataFilter {
    public static final String INTERNAL_SNIPPET_ANALYSIS_FILE_PREFIX = "snippet-analysis-file";
    private final List<RepositoryConnectorShallowConfig> connectorShallowConfigs;
    private final RepositoryOriginalPathIndex originalPathIndex;

    public PreCommitUploadDataFilter(List<RepositoryConnectorShallowConfig> connectorShallowConfigs, RepositoryOriginalPathIndex originalPathIndex) {
        this.connectorShallowConfigs = connectorShallowConfigs;
        this.originalPathIndex = originalPathIndex;
    }

    public Map<String, PrecommitFile> filterUploadData(Map<String, @Nullable String> uploadData, Set<ELanguage> acceptedLanguages, Consumer<PreCommit3Result.PreCommit3ErrorDetail> errorCallback) throws StorageException {
        List<RepositoryConnectorShallowConfig> relevantConnectors = this.connectorShallowConfigs.stream().filter(config -> !config.sourceLibraryConnector).filter(config -> ERepositoryConnector.findByReadableName((String)config.getType()).map(ERepositoryConnector::isIgnoredByPreCommit3).orElse(false) == false).toList();
        if (relevantConnectors.isEmpty()) {
            errorCallback.accept(PreCommit3Result.PreCommit3ErrorDetail.createFileIndependentError((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.NO_VALID_CONNECTOR, (String)"The project has no connector which accepts pre-commits.", (boolean)true));
            return Collections.emptyMap();
        }
        HashSet<String> notYetRetainedUniformPaths = new HashSet<String>(uploadData.keySet());
        HashMap<String, PrecommitFile> retainedUploadData = HashMap.newHashMap(uploadData.size());
        HashMap<String, EExclusionReason> exclusionReasonForUniformPaths = HashMap.newHashMap(uploadData.size());
        for (RepositoryConnectorShallowConfig repositoryConnectorShallowConfig : relevantConnectors) {
            this.filterAgainstConnector(repositoryConnectorShallowConfig, uploadData, notYetRetainedUniformPaths, retainedUploadData, acceptedLanguages, exclusionReasonForUniformPaths);
            if (!exclusionReasonForUniformPaths.isEmpty()) continue;
            break;
        }
        for (Map.Entry entry : exclusionReasonForUniformPaths.entrySet()) {
            String uniformPath = (String)entry.getKey();
            EExclusionReason reason = (EExclusionReason)((Object)entry.getValue());
            errorCallback.accept(PreCommit3Result.PreCommit3ErrorDetail.createErrorForFile((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.FILE_EXCLUDED_BY_PROJECT_CONFIGURATION, (String)reason.getMessage(uniformPath), (String)uniformPath, (boolean)true));
        }
        return retainedUploadData;
    }

    private void filterAgainstConnector(RepositoryConnectorShallowConfig connectorShallowConfig, Map<String, @Nullable String> uploadData, Set<String> notYetRetainedUniformPaths, HashMap<String, PrecommitFile> retainedUploadData, Set<ELanguage> acceptedLanguages, HashMap<String, EExclusionReason> exclusionReasonForUniformPaths) throws StorageException {
        Map originalPathMap = this.originalPathIndex.getRepositoryPaths(connectorShallowConfig.getRepositoryIdentifier(), new ArrayList<String>(uploadData.keySet()));
        for (String uniformPath : notYetRetainedUniformPaths) {
            String fileContent = uploadData.get(uniformPath);
            FileInclusionEvaluationResult inclusionEvaluationResult = PreCommitUploadDataFilter.determineWhetherConnectorWouldIncludeFile(uniformPath, fileContent, connectorShallowConfig, originalPathMap, acceptedLanguages);
            if (inclusionEvaluationResult.included) {
                retainedUploadData.put(uniformPath, new PrecommitFile(uniformPath, inclusionEvaluationResult.isTestCode, fileContent));
                exclusionReasonForUniformPaths.remove(uniformPath);
                continue;
            }
            EExclusionReason exclusionReason = inclusionEvaluationResult.exclusionReason;
            exclusionReasonForUniformPaths.putIfAbsent(uniformPath, exclusionReason);
            if (exclusionReasonForUniformPaths.get(uniformPath).compareTo(exclusionReason) <= 0) continue;
            exclusionReasonForUniformPaths.put(uniformPath, exclusionReason);
        }
        notYetRetainedUniformPaths.removeAll(retainedUploadData.keySet());
    }

    private static FileInclusionEvaluationResult determineWhetherConnectorWouldIncludeFile(String uniformPath, @Nullable String fileContent, RepositoryConnectorShallowConfig connectorShallowConfig, Map<String, String> originalPathMap, Set<ELanguage> acceptedLanguages) {
        FileInclusionEvaluationResult inclusionEvaluation = PreCommitUploadDataFilter.fileIsIncluded(uniformPath, connectorShallowConfig, originalPathMap);
        if (!inclusionEvaluation.included) {
            if (uniformPath.startsWith(INTERNAL_SNIPPET_ANALYSIS_FILE_PREFIX) && !Sets.intersection(acceptedLanguages, (Set)ELanguage.getAllLanguagesForPath((String)uniformPath)).isEmpty()) {
                return new FileInclusionEvaluationResult(true, connectorShallowConfig.isTestCode(uniformPath), EExclusionReason.NONE);
            }
            return new FileInclusionEvaluationResult(false, false, EExclusionReason.INCLUDE_EXCLUDE_PATTERN);
        }
        if (fileContent != null && connectorShallowConfig.isContentExcluded(fileContent)) {
            return new FileInclusionEvaluationResult(false, false, EExclusionReason.CONTENT_EXCLUDE);
        }
        return inclusionEvaluation;
    }

    private static FileInclusionEvaluationResult fileIsIncluded(String uniformPath, RepositoryConnectorShallowConfig connectorShallowConfig, Map<String, String> originalPathMap) {
        String uniformPathWithoutRepoIdentifier = StringUtils.stripPrefix((String)uniformPath, (String)connectorShallowConfig.getPrependedConnectorIdentifier());
        if (connectorShallowConfig.fileIsIncluded(uniformPathWithoutRepoIdentifier)) {
            return new FileInclusionEvaluationResult(true, connectorShallowConfig.isTestCode(uniformPathWithoutRepoIdentifier), EExclusionReason.NONE);
        }
        String repositoryPath = originalPathMap.get(uniformPath);
        if (repositoryPath != null && connectorShallowConfig.fileIsIncluded(repositoryPath)) {
            return new FileInclusionEvaluationResult(true, connectorShallowConfig.isTestCode(repositoryPath), EExclusionReason.NONE);
        }
        return connectorShallowConfig.fileIsIncludedWithTransformations(uniformPathWithoutRepoIdentifier);
    }

    static enum EExclusionReason {
        NONE(null),
        INCLUDE_EXCLUDE_PATTERN("%s is excluded by project include/exclude-path pattern."),
        CONTENT_EXCLUDE("%s is excluded by project content-exclude pattern.");

        private final String message;

        private EExclusionReason(String message) {
            this.message = message;
        }

        @VisibleForTesting
        String getMessage(String uniformPath) {
            if (this.message == null) {
                return null;
            }
            return String.format(this.message, uniformPath);
        }
    }

    public record FileInclusionEvaluationResult(boolean included, boolean isTestCode, EExclusionReason exclusionReason) {
    }

    public record PrecommitFile(String uniformPath, boolean isTestCode, @Nullable String fileContent) {
        public boolean isDeleted() {
            return this.fileContent == null;
        }
    }
}

