/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit;

import com.google.common.base.Splitter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.BooleanOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.CollectionOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapRepositoryConnectorDescriptor;
import com.teamscale.service.precommit.PreCommitUploadDataFilter;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.string.RegexReplacement;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class RepositoryConnectorShallowConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Pattern, ELanguage> languageMapping;
    private final PatternList compiledContentExcludePatterns;
    final boolean sourceLibraryConnector;
    private final IncludeExcludeAntPatternSupport includeExcludePattern;
    private final IncludeExcludeAntPatternSupport testCodeIncludeExcludePattern;
    private final String prependedConnectorIdentifier;
    private final String type;
    private final UnmodifiableList<RegexReplacement> reversedPathTransformations;
    private final String repositoryIdentifier;

    RepositoryConnectorShallowConfig(ConnectorConfiguration connectorConfiguration) {
        this.type = connectorConfiguration.getRawType();
        this.repositoryIdentifier = connectorConfiguration.getIdentifier();
        this.includeExcludePattern = RepositoryConnectorShallowConfig.extractIncludeExcludeAntPatternSupport(connectorConfiguration);
        this.testCodeIncludeExcludePattern = RepositoryConnectorShallowConfig.extractIncludeExcludeTestCodeAntPatternSupport(connectorConfiguration);
        this.sourceLibraryConnector = RepositoryConnectorShallowConfig.extractSourceLibraryConnectorOption(connectorConfiguration);
        this.languageMapping = RepositoryConnectorShallowConfig.extractLanguageMapping(connectorConfiguration);
        this.compiledContentExcludePatterns = RepositoryConnectorShallowConfig.extractContentExcludePatterns(connectorConfiguration);
        this.prependedConnectorIdentifier = RepositoryConnectorShallowConfig.extractPrependedConnectorIdentifier(connectorConfiguration);
        this.reversedPathTransformations = RepositoryConnectorShallowConfig.extractReversedPathPrefixTransformation(connectorConfiguration);
    }

    private static String extractPrependedConnectorIdentifier(ConnectorConfiguration connectorConfiguration) {
        boolean identifierIsPrepended = Boolean.parseBoolean(connectorConfiguration.getOptionValue("Prepend Connector Identifier"));
        if (!identifierIsPrepended) {
            return "";
        }
        String connectorIdentifier = connectorConfiguration.getOptionValue("Connector Identifier");
        return connectorIdentifier + "/";
    }

    private static @NonNull IncludeExcludeAntPatternSupport extractIncludeExcludeAntPatternSupport(ConnectorConfiguration connectorConfiguration) {
        String excludeOptionValue;
        String includeOptionValue = connectorConfiguration.getOptionValue("Included file names");
        if (includeOptionValue == null) {
            includeOptionValue = "";
        }
        if ((excludeOptionValue = connectorConfiguration.getOptionValue("Excluded file names")) == null) {
            excludeOptionValue = "";
        }
        List testCodeIncludePatterns = CollectionOptionDescriptorBase.parseStringToListOfStrings((String)includeOptionValue);
        List testCodeExcludePatterns = CollectionOptionDescriptorBase.parseStringToListOfStrings((String)excludeOptionValue);
        return new IncludeExcludeAntPatternSupport(testCodeIncludePatterns, testCodeExcludePatterns);
    }

    private static @NonNull IncludeExcludeAntPatternSupport extractIncludeExcludeTestCodeAntPatternSupport(ConnectorConfiguration connectorConfiguration) {
        String excludeOptionValue;
        String includeOptionValue = connectorConfiguration.getOptionValue("Test-code path pattern");
        if (includeOptionValue == null) {
            includeOptionValue = "";
        }
        if ((excludeOptionValue = connectorConfiguration.getOptionValue("Test-code path exclude pattern")) == null) {
            excludeOptionValue = "";
        }
        List testCodeIncludePatterns = CollectionOptionDescriptorBase.parseStringToListOfStrings((String)includeOptionValue);
        List testCodeExcludePatterns = CollectionOptionDescriptorBase.parseStringToListOfStrings((String)excludeOptionValue);
        return new IncludeExcludeAntPatternSupport(testCodeIncludePatterns, testCodeExcludePatterns);
    }

    private static boolean extractSourceLibraryConnectorOption(ConnectorConfiguration connectorConfiguration) {
        try {
            String optionValue = connectorConfiguration.getOptionValue("Source library connector");
            if (optionValue == null) {
                return false;
            }
            return BooleanOptionDescriptor.parseBoolean((String)optionValue, (String)"Source library connector");
        }
        catch (ProjectConfigurationException e) {
            LOGGER.warn("Exception while parsing option \"SourceLibraryConnector\" of connector " + connectorConfiguration.getIdentifier() + ". Assuming false.", (Throwable)e);
            return false;
        }
    }

    private static @NonNull PatternList extractContentExcludePatterns(ConnectorConfiguration connectorConfiguration) {
        List<String> contentExcludePatterns = RepositoryConnectorShallowConfig.collectExcludePatterns(connectorConfiguration);
        try {
            PatternList compiledContentExcludePatterns = new PatternList();
            for (String contentExcludePattern : contentExcludePatterns) {
                compiledContentExcludePatterns.add((Object)CommonUtils.compilePattern((String)contentExcludePattern));
            }
            return compiledContentExcludePatterns;
        }
        catch (ConQATException e) {
            LOGGER.warn("Exception while parsing option \"Content exclude\" of connector {}. Assuming no content excludes.", (Object)connectorConfiguration.getIdentifier(), (Object)e);
            return new PatternList();
        }
    }

    private static List<String> collectExcludePatterns(ConnectorConfiguration connectorConfiguration) {
        ArrayList<String> patterns = new ArrayList<String>();
        String basePatterns = connectorConfiguration.getOptionValue("Content exclude");
        if (basePatterns != null) {
            patterns.addAll(CollectionOptionDescriptorBase.parseStringToListOfStrings((String)basePatterns));
        }
        if (connectorConfiguration.isRepositoryType(ERepositoryConnector.ABAP_GIT)) {
            patterns.addAll(AbapRepositoryConnectorDescriptor.GENERATED_CODE_PATTERNS);
            String abapPatterns = connectorConfiguration.getOptionValue("Content exclude (ABAP)");
            if (abapPatterns != null) {
                patterns.addAll(CollectionOptionDescriptorBase.parseStringToListOfStrings((String)abapPatterns));
            }
        }
        return patterns;
    }

    private static @NonNull Map<Pattern, ELanguage> extractLanguageMapping(ConnectorConfiguration connectorConfiguration) {
        try {
            String optionValue = connectorConfiguration.getOptionValue("Language mapping");
            if (optionValue == null) {
                return Collections.emptyMap();
            }
            PairList languageMappingOption = StringValuePairListOptionDescriptor.parseFromString((String)optionValue);
            HashMap<Pattern, ELanguage> parsedLanguageMappings = new HashMap<Pattern, ELanguage>();
            for (Pair languageMappingEntry : languageMappingOption) {
                Pattern pattern = AntPatternUtils.convertPattern((String)((String)languageMappingEntry.getFirst()), (boolean)false);
                ELanguage language = ELanguage.valueOf((String)((String)languageMappingEntry.getSecond()));
                parsedLanguageMappings.put(pattern, language);
            }
            return parsedLanguageMappings;
        }
        catch (ProjectConfigurationException | IllegalArgumentException e) {
            LOGGER.warn("Exception while parsing option \"Language mapping\" of connector " + connectorConfiguration.getIdentifier() + ". Assuming no language mappings.", e);
            return Collections.emptyMap();
        }
    }

    private static UnmodifiableList<RegexReplacement> extractReversedPathPrefixTransformation(ConnectorConfiguration connectorConfiguration) {
        ArrayList<RegexReplacement> result = new ArrayList<RegexReplacement>();
        result.addAll(RepositoryConnectorShallowConfig.fillReversedPathTransformation(connectorConfiguration.getOptionValue("Path prefix transformation"), "^"));
        result.addAll(RepositoryConnectorShallowConfig.fillReversedPathTransformation(connectorConfiguration.getOptionValue("Path transformation"), ""));
        return CollectionUtils.asUnmodifiable(result);
    }

    private static List<RegexReplacement> fillReversedPathTransformation(String transformationString, String prefix) {
        if (StringUtils.isEmpty((String)transformationString)) {
            return Collections.emptyList();
        }
        ArrayList<RegexReplacement> reversedTransformation = new ArrayList<RegexReplacement>();
        for (String singleTransformationString : transformationString.split(",")) {
            List split = Splitter.on((String)"->").limit(2).trimResults().splitToList((CharSequence)singleTransformationString);
            reversedTransformation.add(0, new RegexReplacement(prefix + (String)split.get(1), (String)split.get(0)));
        }
        return reversedTransformation;
    }

    public PreCommitUploadDataFilter.FileInclusionEvaluationResult fileIsIncludedWithTransformations(String uniformPath) {
        if (this.reversedPathTransformations.isEmpty()) {
            return new PreCommitUploadDataFilter.FileInclusionEvaluationResult(false, false, null);
        }
        LinkedList<Pair> transformations = new LinkedList<Pair>();
        for (int i = 0; i < this.reversedPathTransformations.size(); ++i) {
            transformations.offer(Pair.createPair((Object)uniformPath, (Object)i));
        }
        while (!transformations.isEmpty()) {
            String replacement;
            Integer currentTransformation;
            RegexReplacement expr;
            Matcher matcher;
            String transformedPath;
            Pair pair = (Pair)transformations.poll();
            String currentPath = (String)pair.getFirst();
            if (Objects.equals(currentPath, transformedPath = (matcher = (expr = (RegexReplacement)this.reversedPathTransformations.get((currentTransformation = (Integer)pair.getSecond()).intValue())).getPattern().matcher(currentPath)).replaceAll(replacement = expr.getReplacement()))) continue;
            if (this.fileIsIncluded(transformedPath)) {
                return new PreCommitUploadDataFilter.FileInclusionEvaluationResult(true, this.isTestCode(transformedPath), PreCommitUploadDataFilter.EExclusionReason.NONE);
            }
            for (int i = currentTransformation + 1; i < this.reversedPathTransformations.size(); ++i) {
                transformations.offer(Pair.createPair((Object)transformedPath, (Object)i));
            }
        }
        return new PreCommitUploadDataFilter.FileInclusionEvaluationResult(false, false, PreCommitUploadDataFilter.EExclusionReason.INCLUDE_EXCLUDE_PATTERN);
    }

    public boolean fileIsIncluded(String uniformPath) {
        return this.includeExcludePattern.isIncluded(uniformPath);
    }

    public boolean isTestCode(String uniformPath) {
        return this.testCodeIncludeExcludePattern.isIncluded(uniformPath);
    }

    public boolean isContentExcluded(String fileContent) {
        return this.compiledContentExcludePatterns.findsAnyIn(fileContent);
    }

    public String getType() {
        return this.type;
    }

    public String getRepositoryIdentifier() {
        return this.repositoryIdentifier;
    }

    public Optional<ELanguage> getLanguageMapping(String path) {
        for (Map.Entry<Pattern, ELanguage> entry : this.languageMapping.entrySet()) {
            if (!entry.getKey().matcher(path).matches()) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public String getPrependedConnectorIdentifier() {
        return this.prependedConnectorIdentifier;
    }

    public Optional<ERepositoryConnector> getRepositoryType() {
        return ERepositoryConnector.findByReadableName((String)this.getType());
    }
}

