/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class ConnectorDescriptorTransport {
    private static final String NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String LONG_DESCRIPTION_PROPERTY = "longDescription";
    private static final String URL_PROPERTY = "url";
    private static final String CONNECTOR_TYPE_PROPERTY = "connectorType";
    private static final String CONNECTOR_ENUM_PROPERTY = "connectorEnum";
    private static final String OPTIONS_PROPERTY = "options";
    private static final String LOGO_URL_PROPERTY = "logoUrl";
    private static final String IS_BETA_PROPERTY = "isBeta";
    private static final String CONNECTOR_IDENTIFIER_OPTION_NAME_PROPERTY = "connectorIdentifierOptionName";
    @JsonProperty(value="name")
    public final String name;
    @JsonProperty(value="description")
    public final String description;
    @JsonProperty(value="longDescription")
    public final @Nullable String longDescription;
    @JsonProperty(value="url")
    public final String url;
    @JsonProperty(value="isBeta")
    public final Boolean isBeta;
    @JsonProperty(value="connectorType")
    public final EConnectorType connectorType;
    @JsonProperty(value="connectorEnum")
    public final String connectorEnum;
    @JsonProperty(value="connectorIdentifierOptionName")
    public final String connectorIdentifierOptionName;
    @JsonProperty(value="options")
    public final List<ConfigOptionDescriptorBase> options;
    @JsonProperty(value="logoUrl")
    public final @Nullable String logoUrl;

    @JsonCreator
    public ConnectorDescriptorTransport(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="longDescription") @Nullable String longDescription, @JsonProperty(value="url") String url, @JsonProperty(value="connectorType") EConnectorType connectorType, @JsonProperty(value="connectorEnum") String connectorEnum, @JsonProperty(value="connectorIdentifierOptionName") String connectorIdentifierOptionName, @JsonProperty(value="options") List<ConfigOptionDescriptorBase> options, @JsonProperty(value="logoUrl") @Nullable String logoUrl, @JsonProperty(value="isBeta") Boolean isBeta) {
        this.name = name;
        this.description = description;
        this.longDescription = longDescription;
        this.url = url;
        this.connectorType = connectorType;
        this.connectorEnum = connectorEnum;
        this.connectorIdentifierOptionName = connectorIdentifierOptionName;
        this.options = options;
        this.logoUrl = logoUrl;
        this.isBeta = isBeta;
    }

    public ConnectorDescriptorTransport(ConnectorDescriptorBase descriptor) {
        this.name = descriptor.getName();
        this.description = descriptor.getDescription();
        this.longDescription = descriptor.getLongDescription();
        this.url = descriptor.getUrl();
        this.connectorType = descriptor.getConnectorType();
        this.connectorEnum = ((Enum)descriptor.connectorEnum).name();
        this.logoUrl = descriptor.getLogoUrl();
        this.isBeta = descriptor.isBeta();
        this.connectorIdentifierOptionName = descriptor.getConnectorIdentifierOptionName();
        this.options = CollectionUtils.sort((Collection)descriptor.getVisibleOptions(), (Comparator)ConfigOptionDescriptorBase.getComparator());
    }

    public String getName() {
        return this.name;
    }
}

