/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.service.project.ProjectPlatformLinks;
import jakarta.ws.rs.BadRequestException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.lang.ObjectUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class ProjectPlatformLinkUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static @NonNull Map<String, ProjectPlatformLinks> determineProjectPlatformLinksMap(PublicProjectId projectId, IndexLayer indexLayer) throws StorageException {
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)ObjectUtils.requireNonNullElseThrow((Object)ProjectUtils.retrieveProjectConfig((IProjectId)projectId, (IndexLayer)indexLayer), () -> new BadRequestException("Could not find a project for id: " + String.valueOf(projectId)));
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        HashMap<String, ProjectPlatformLinks> result = new HashMap<String, ProjectPlatformLinks>();
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            if (!connector.isGitBased() || connector.isRepositoryType(ERepositoryConnector.ABAP_GIT)) continue;
            try {
                result.put(connector.getIdentifier(), ProjectPlatformLinkUtils.getProjectPlatformLinks(connector.getIdentifier(), projectMetaIndex));
            }
            catch (ProjectConfigurationException | StorageException e) {
                LOGGER.log(Level.ERROR, "Could not read ProjectPlatformLinks from MetaIndex", e);
            }
        }
        return result;
    }

    private static ProjectPlatformLinks getProjectPlatformLinks(String connectorIdentifier, MetaIndex projectMetaIndex) throws ProjectConfigurationException, StorageException {
        Optional commitLink = projectMetaIndex.getExternalLinkTemplateForCommit(connectorIdentifier);
        Optional commitInMergeRequestLink = projectMetaIndex.getExternalLinkTemplateForCommitInMergeRequest(connectorIdentifier);
        if (commitLink.isEmpty() || commitInMergeRequestLink.isEmpty()) {
            throw new ProjectConfigurationException("Could not find external link templates for connector " + connectorIdentifier);
        }
        return new ProjectPlatformLinks((String)commitLink.get(), (String)commitInMergeRequestLink.get());
    }

    private ProjectPlatformLinkUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

