/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.user.User;
import com.teamscale.core.utils.TimestampedInteraction;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.user.UserRecentlyCommittedCommitsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

@Path(value="api/recent/commits")
public class GlobalUserRecentCommitsService
extends ApiBase {
    private static final int MAX_RECENT_COMMITS = 5;

    @GET
    @Operation(summary="Get recent commits", description="Returns the recently committed commits.", tags={"Project"})
    @RequiresNoPermission
    public @NonNull List<RepositoryLogEntryWithProject> getRecentCommits() throws StorageException {
        List projects = PermissionUtils.getVisibleProjectIds((GlobalStorageSystem)this.getGlobalStorageSystem(), (ServicePermissions)this.getPermissions(), List.of());
        if (projects.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ArrayList<RepositoryLogEntryWithProject> globalRecentCommits = new ArrayList<RepositoryLogEntryWithProject>();
        for (PublicProjectId projectId : projects) {
            CommitResolvingStorageSystem projectStorageSystem = this.serviceInfo.getProjectStorageSystem((IProjectId)projectId);
            List<CommitDescriptor> recentCommits = GlobalUserRecentCommitsService.getRecentCommits(projectStorageSystem, this.getUser());
            List<RepositoryLogEntry> entries = ((RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null)).getEntries(recentCommits).stream().filter(Objects::nonNull).filter(entry -> !PreCommitUtils.isPrecommitCommit((CommitDescriptor)entry.getCommit())).map(RepositoryLogEntryAggregate::toAggregateLogEntryWithPrimaryConnector).toList();
            List<ExtendedRepositoryLogEntry> extendedEntries = LogEntryResolver.of(this.serviceInfo.getGlobalStorageSystem(), projectStorageSystem, projectId, this.serviceInfo.getIndexLayer()).resolveExtendedRepositoryLogEntry(entries, null);
            for (ExtendedRepositoryLogEntry entry2 : extendedEntries) {
                globalRecentCommits.add(new RepositoryLogEntryWithProject(projectId, entry2));
            }
        }
        return globalRecentCommits.stream().sorted(Comparator.comparing(RepositoryLogEntryWithProject::getTimestamp).reversed()).limit(5L).toList();
    }

    private static @NonNull List<CommitDescriptor> getRecentCommits(CommitResolvingStorageSystem projectStorageSystem, User user) throws StorageException {
        UserRecentlyCommittedCommitsIndex userRecentlyInteractedBranchesIndex = (UserRecentlyCommittedCommitsIndex)projectStorageSystem.openProjectIndex(UserRecentlyCommittedCommitsIndex.class, null);
        return userRecentlyInteractedBranchesIndex.getRecentCommits(user).stream().limit(5L).map(TimestampedInteraction::identifier).toList();
    }

    public record RepositoryLogEntryWithProject(PublicProjectId projectId, ExtendedRepositoryLogEntry logEntry) {
        long getTimestamp() {
            return this.logEntry.getCommit().getTimestamp();
        }
    }
}

