/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLastChangeUtils;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/repository")
public class RepositoryLastChangeService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Return last change log entry", description="Returns the log entry for the last change containing the given file.", tags={"Project"}, responses={@ApiResponse(responseCode="204", description="No change was found for the given uniform path.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="last-change/{uniformPath}")
    public RepositoryLogEntry getLastChangeLogEntry(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="exclude-non-code-commits") @Parameter(description="Whether non-code commits such as external uploads and code reviews should be ignored for the last change date.") boolean excludeExternalUploads, @ResolveToCodePath @PathParam(value="uniformPath") UniformPath uniformPath) throws StorageException {
        Optional logEntry = RepositoryLastChangeUtils.findLastChangeForElement((String)uniformPath.toStringAsMigrationFrontier(), (CommitDescriptor)this.resolve(commit), (boolean)excludeExternalUploads, (ProjectStorageSystem)this.getProjectStorageSystem(), (Logger)LOGGER);
        return logEntry.map(RepositoryLogEntryAggregate::toAggregateLogEntryWithPrimaryConnector).orElse(null);
    }

    @GET
    @Operation(summary="Return last change log entry with the given commit type", description="Returns the log entry for the last change with the given commit type", tags={"Project"}, responses={@ApiResponse(responseCode="204", description="No change with the given commit type")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="last-commit")
    public RepositoryLogEntryAggregate getLastCommitOfType(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="commit-type") ECommitType commitType) throws StorageException {
        Optional logEntry = RepositoryLastChangeUtils.findLastRepositoryEntryOfType((CommitDescriptor)this.resolve(commit), (ECommitType)commitType, (SchemaAwareStorageSystem)this.getProjectStorageSystem());
        return logEntry.orElse(null);
    }
}

