/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing.schema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.issues.IExternalToolLinkRoleResolverProvider;
import com.teamscale.index.issues.IssueTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.model.ExternalToolIssueFieldResultBase;
import com.teamscale.index.issues.model.ExternalToolLinkRole;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/spec-items/default/{accountName}/schema")
public class DefaultSpecItemSchemaService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @PathParam(value="accountName")
    private String accountName;

    @PUT
    @Path(value="link-roles")
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="accountName")
    @Operation(summary="Get link roles", description="Returns the link roles for a specific connector.", responses={@ApiResponse(responseCode="400", description="The account from the path did not match the one in the connector configuration")}, tags={"Specification Items", "Connectors"})
    public GetLinkRolesResponse getLinkRoles(@RequestBody ConnectorConfiguration connectorConfiguration) throws StorageException, ProjectConfigurationException {
        IssueTrackerConnectorDescriptorBase connector = this.loadConnector(connectorConfiguration);
        this.verifyCorrectAccountName(connector);
        if (!(connector instanceof IExternalToolLinkRoleResolverProvider)) {
            throw new ProjectConfigurationException("Service called with invalid connector descriptor: " + connector.getName());
        }
        IExternalToolLinkRoleResolverProvider provider = (IExternalToolLinkRoleResolverProvider)connector;
        try {
            return new GetLinkRolesResponse(provider.getLinkRoleResolver().loadLinkRoles());
        }
        catch (ServiceCallException e) {
            String errorMessage = "Error while fetching link roles from: " + connector.getName();
            LOGGER.error(errorMessage, (Throwable)e);
            return new GetLinkRolesResponse(errorMessage + ":\n" + e.getMessage());
        }
    }

    private void verifyCorrectAccountName(IssueTrackerConnectorDescriptorBase connector) {
        String connectorAccountIdentifier = connector.getAccountIdentifier();
        if (!this.accountName.equals(connectorAccountIdentifier)) {
            throw new BadRequestException("Account name from URL (%s) does not match the one from connector configuration (%s)".formatted(this.accountName, connectorAccountIdentifier));
        }
    }

    private IssueTrackerConnectorDescriptorBase loadConnector(ConnectorConfiguration connectorConfiguration) throws StorageException, ProjectConfigurationException {
        GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
        ConnectorDescriptorBase connector = ConnectorUtils.loadConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)new ConfigurationInitializationContext(this.getIndexLayer(), (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class)), null);
        if (!(connector instanceof IssueTrackerConnectorDescriptorBase)) {
            throw new ProjectConfigurationException("Service called with invalid connector descriptor: " + connector.getName());
        }
        IssueTrackerConnectorDescriptorBase credentialsBasedConnector = (IssueTrackerConnectorDescriptorBase)connector;
        return credentialsBasedConnector;
    }

    public static class GetLinkRolesResponse
    extends ExternalToolIssueFieldResultBase {
        @JsonProperty(value="linkRoles")
        private final List<ExternalToolLinkRole> linkRoles;

        private GetLinkRolesResponse(List<ExternalToolLinkRole> linkRoles) {
            super("");
            this.linkRoles = linkRoles;
        }

        private GetLinkRolesResponse(String errorMessage) {
            super(errorMessage);
            this.linkRoles = Collections.emptyList();
        }

        public List<ExternalToolLinkRole> getLinkRoles() {
            return this.linkRoles;
        }
    }
}

