/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.report.ParsedReportIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/parsed-reports/debug")
public class ParsedReportIndexDebugService
extends ApiBase {
    @GET
    @Path(value="report")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get parsed report by path", description="Returns the parsed report for a specific report path at the given commit.", tags={"Debugging"})
    public ParsedReportDto getReportByPath(@QueryParam(value="path") String reportPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") @Nullable UnresolvedCommitDescriptor commit) throws StorageException {
        ParsedReportIndex index = this.openParsedReportIndex(commit);
        List reports = index.getReports(List.of(reportPath));
        ParsedReportIndex.ParsedReport report = (ParsedReportIndex.ParsedReport)reports.getFirst();
        if (report == null) {
            throw new NotFoundException("Report not found at path: " + reportPath);
        }
        return ParsedReportDto.from(reportPath, report);
    }

    @GET
    @Path(value="partition/{partitionName}/paths")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get report paths for partition", description="Returns all report paths for a specific partition at the given commit.", tags={"Debugging"})
    public Set<String> getReportPathsForPartition(@PathParam(value="partitionName") String partitionName, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") @Nullable UnresolvedCommitDescriptor commit) throws StorageException {
        return this.openParsedReportIndex(commit).getAllReportsForPartition(partitionName).orElseGet(Collections::emptySet);
    }

    private ParsedReportIndex openParsedReportIndex(@Nullable UnresolvedCommitDescriptor commit) throws StorageException {
        return (ParsedReportIndex)this.getProjectStorageSystem().openProjectIndex(ParsedReportIndex.class, this.determineHistoryOption(commit));
    }

    public record ParsedReportDto(@JsonProperty(value="reportPath") String reportPath, @JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="partitions") Set<String> partitions, @JsonProperty(value="importInfoCount") int importInfoCount) {
        static ParsedReportDto from(String reportPath, ParsedReportIndex.ParsedReport report) {
            Set<String> partitions = report.importInfos().getInfos().stream().map(ExternalAnalysisImportInfo::getPartition).collect(Collectors.toSet());
            return new ParsedReportDto(reportPath, report.connectorId(), partitions, report.importInfos().getInfos().size());
        }
    }
}

