/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.ReportPartitionOriginIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/report-partition-origins/debug")
public class ReportPartitionOriginDebugService
extends ApiBase {
    @GET
    @Path(value="partition/{partitionName}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get report partition origin", description="Returns the origin information for a specific report partition.", tags={"Debugging"})
    public ReportPartitionOriginDto getPartitionOrigin(@PathParam(value="partitionName") String partitionName, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") @Nullable UnresolvedCommitDescriptor commit) throws StorageException {
        ReportPartitionOriginIndex index = this.openReportPartitionOriginIndex(commit);
        Map allOrigins = index.loadAllPartitionOrigins();
        ReportPartitionOriginIndex.ReportPartitionOrigin origin = (ReportPartitionOriginIndex.ReportPartitionOrigin)allOrigins.get(partitionName);
        if (origin == null) {
            throw new NotFoundException("No partition origin found for partition: " + partitionName);
        }
        return ReportPartitionOriginDto.from(origin);
    }

    @GET
    @Path(value="all-partitions")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all report partition origins", description="Returns origin information for all report partitions.", tags={"Debugging", "External Analysis"})
    public Map<String, ReportPartitionOriginDto> getAllPartitionOrigins(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") @Nullable UnresolvedCommitDescriptor commit) throws StorageException {
        ReportPartitionOriginIndex index = this.openReportPartitionOriginIndex(commit);
        Map allOrigins = index.loadAllPartitionOrigins();
        return allOrigins.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ReportPartitionOriginDto.from((ReportPartitionOriginIndex.ReportPartitionOrigin)entry.getValue())));
    }

    @GET
    @Path(value="all-partitions/{branch}/head")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all report partition origins on head commit", description="Returns origin information for all report partitions on the current default branch head commit.", tags={"Debugging", "External Analysis"})
    public Map<String, ReportPartitionOriginDto> getAllPartitionOriginsOnHead(@PathParam(value="branch") String branchName) throws StorageException {
        ReportPartitionOriginIndex index = (ReportPartitionOriginIndex)this.getProjectStorageSystem().openProjectIndex(ReportPartitionOriginIndex.class, HistoryAccessOption.readHead((String)branchName));
        Map allOrigins = index.loadAllPartitionOrigins();
        return allOrigins.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ReportPartitionOriginDto.from((ReportPartitionOriginIndex.ReportPartitionOrigin)entry.getValue())));
    }

    private ReportPartitionOriginIndex openReportPartitionOriginIndex(@Nullable UnresolvedCommitDescriptor commit) throws StorageException {
        return (ReportPartitionOriginIndex)this.getProjectStorageSystem().openProjectIndex(ReportPartitionOriginIndex.class, this.determineHistoryOption(commit));
    }

    public record ReportPartitionOriginDto(@JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="originConnectorId") String originConnectorId, @JsonProperty(value="connectorType") ERepositoryConnector connectorType, @JsonProperty(value="reportDeletionBehavior") ReportPartitionOriginIndex.EReportDeletionBehavior reportDeletionBehavior) {
        private static ReportPartitionOriginDto from(ReportPartitionOriginIndex.ReportPartitionOrigin origin) {
            return new ReportPartitionOriginDto(origin.partitionName(), origin.originConnectorId(), origin.connectorType(), origin.reportDeletionBehavior());
        }
    }
}

