/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.simulink;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.resource.simulink.SimulinkOpaqueLibrariesOptionContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Comparator;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;

@Path(value="api/projects/{project}/simulink/dictionary/{uniformPath: .*}")
public class SimulinkDataDictionaryService
extends ApiBase {
    @GET
    @Operation(summary="Get simulink data dictionary entries", description="Returns the content for the specified view in a simulink data dictionary (.sldd). ", tags={"Simulink"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, SimulinkOpaqueLibrariesOptionContributor.class})
    public PairList<String, String> getSimulinkDataDictionaryEntries(@PathParam(value="uniformPath") String uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        SimulinkDataDictionaryIndex index = this.openProjectIndex(SimulinkDataDictionaryIndex.class, historyAccessOption);
        PairList result = new PairList();
        SimulinkDataDictionary dictionary = index.getDataDictionaryByUniformPath(uniformPath);
        for (ISimulinkDataDictionaryEntry entry : dictionary.getEntries()) {
            result.add((Object)entry.getEntryType(), (Object)entry.getName());
        }
        result.sort(Comparator.comparing(ImmutablePair::getSecond));
        return result;
    }
}

