/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reviews;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.reviews.CodeReviewBaselineOption;
import com.teamscale.index.reviews.ElementReviewChangeRetriever;
import com.teamscale.index.reviews.ElementReviewCommit;
import com.teamscale.index.reviews.ElementReviewStatus;
import com.teamscale.index.reviews.ElementReviewStatusIndex;
import com.teamscale.index.reviews.ElementReviewUploadIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/{uniformPath}/review-status")
public class ElementReviewStatusService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get review status", description="Allows to retrieve the review status for a file.", tags={"Source Code"}, responses={@ApiResponse(responseCode="204", description="The review feature is not enabled.")})
    public AssessedReviewStatus getReviewStatus(@Parameter(description="The uniform path of the file for which the review status should be retrieved") @PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        if (!this.getProjectStorageSystem().hasIndex("element-review-uploads") || !uniformPath.isCodePath()) {
            return null;
        }
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        return this.determineRating(uniformPath, commit, userAliasLookup).orElse(null);
    }

    private Optional<AssessedReviewStatus> determineRating(UniformPath uniformPath, UnresolvedCommitDescriptor commit, UserAliasLookup userAliasLookup) throws StorageException {
        Optional<Assessment> reviewRating;
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ElementReviewStatusIndex reviewStatusIndex = this.openProjectIndex(ElementReviewStatusIndex.class, historyAccessOption);
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        long baseline = CodeReviewBaselineOption.getBaselineOption((ProjectOptionIndex)projectOptionIndex);
        ElementReviewStatus reviewStatus = reviewStatusIndex.getReviewStatus(uniformPath);
        if (reviewStatus != null && reviewStatus.getTimestamp() <= baseline) {
            reviewStatus = null;
        }
        if ((reviewRating = this.getReviewRating(uniformPath, historyAccessOption)).isEmpty()) {
            return Optional.empty();
        }
        User lastChangeUser = null;
        if (reviewStatus != null) {
            lastChangeUser = userAliasLookup.resolveUser(reviewStatus.getLastChangeUser()).orElse(null);
        }
        return Optional.of(ElementReviewStatusService.getAssessedReviewStatus(reviewStatus, reviewRating.get(), lastChangeUser));
    }

    @NotNull
    private static AssessedReviewStatus getAssessedReviewStatus(ElementReviewStatus reviewStatus, Assessment assessment, User lastChangeUser) {
        if (reviewStatus == null) {
            return new AssessedReviewStatus(ElementReviewCommit.EReviewStatus.NONE, assessment.getDominantColor());
        }
        if (reviewStatus.getStatus() != ElementReviewCommit.EReviewStatus.REWORK && assessment.getDominantColor() == ETrafficLightColor.RED) {
            return new AssessedReviewStatus(ElementReviewCommit.EReviewStatus.UNREVIEWED_CHANGES, ETrafficLightColor.RED);
        }
        return new AssessedReviewStatus(reviewStatus, assessment.getDominantColor(), lastChangeUser);
    }

    private Optional<Assessment> getReviewRating(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        MetricDirectoryEntry metricDirectoryEntry = metricRetrievalStrategy.getMetricDirectoryEntry(uniformPath, historyAccessOption);
        if (metricDirectoryEntry == null) {
            return Optional.of(new Assessment(ETrafficLightColor.UNKNOWN));
        }
        MetricDirectorySchema schema = metricRetrievalStrategy.getMetricDirectorySchema(historyAccessOption.cloneToUnbranchedAccessOption());
        return Optional.ofNullable((Assessment)metricDirectoryEntry.getValueWithoutNullAssert(schema.getValuePosition("Review Rating")));
    }

    @POST
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Set review status", description="Allows to retrieve the review status for a file.", tags={"Source Code"})
    public void setReviewStatus(@Parameter(description="The uniform path of the file for which the review status should be changed") @PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @RequestBody(required=true) ReviewUploadInfo uploadInfo) throws StorageException {
        User user = this.getUser();
        String branch = commit.getBranchName();
        if (branch == null) {
            branch = this.getDefaultBranchName();
        }
        long currentTime = System.currentTimeMillis();
        CommitDescriptor uploadCommit = new CommitDescriptor(branch, currentTime);
        ElementReviewUploadIndex uploadIndex = this.openProjectIndex(ElementReviewUploadIndex.class, HistoryAccessOption.readHeadWriteTimestamp((String)uploadCommit.getBranchName(), (long)uploadCommit.getTimestamp()));
        uploadIndex.setCommitInfo((Serializable)new ElementReviewCommit(uploadCommit, user.getUsername(), uniformPath.toString(), uploadInfo.getReviewStatus()));
        this.scheduleChangeRetriever();
    }

    private void scheduleChangeRetriever() throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.serviceInfo.getIndexLayer(), this.serviceInfo.getInternalId(), ElementReviewChangeRetriever.class);
    }

    public static class AssessedReviewStatus {
        @JsonUnwrapped
        private final ElementReviewStatus status;
        @JsonProperty(value="color")
        private final ETrafficLightColor color;
        @JsonProperty(value="resolvedLastChangeUser")
        private final @Nullable User resolvedLastChangeUser;

        private AssessedReviewStatus(ElementReviewStatus status, ETrafficLightColor color, @Nullable User resolvedLastChangeUser) {
            this.status = status;
            this.color = color;
            this.resolvedLastChangeUser = resolvedLastChangeUser;
        }

        private AssessedReviewStatus(ElementReviewCommit.EReviewStatus status, ETrafficLightColor color) {
            this.status = new ElementReviewStatus(status, null, -1L);
            this.color = color;
            this.resolvedLastChangeUser = null;
        }
    }

    public static class ReviewUploadInfo {
        private static final String REVIEW_STATUS_PROPERTY = "reviewStatus";
        @JsonProperty(value="reviewStatus")
        private final ElementReviewCommit.EReviewStatus reviewStatus;

        @JsonCreator
        public ReviewUploadInfo(@JsonProperty(value="reviewStatus") ElementReviewCommit.EReviewStatus reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        private ElementReviewCommit.EReviewStatus getReviewStatus() {
            return this.reviewStatus;
        }

        public String toString() {
            return this.reviewStatus.name();
        }
    }
}

