/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.search.CodeSearchTreemapBuilderBase;
import com.teamscale.service.search.result.SearchHitBase;
import java.awt.Color;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class RegularCodeSearchTreeMapBuilder
extends CodeSearchTreemapBuilderBase {
    private final List<SearchHitBase> searchHits;

    public RegularCodeSearchTreeMapBuilder(String searchQuery, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, int colorMetricIndex, Object colorMetricDefault, Color baseColor, boolean isColorGradationActive, List<SearchHitBase> searchHits) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, new MetricTreemapBuilderParameters(null, null, colorMetricIndex, colorMetricDefault, baseColor), searchQuery, isColorGradationActive);
        this.searchHits = searchHits;
    }

    @Override
    protected FilteredTreeMapWrapper computeSearchCountValues(List<MetricDirectoryEntry> entries) throws StorageException {
        int filesIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Files");
        int locIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Lines of Code");
        int overallFiles = (int)entries.get(0).getDoubleValue(filesIndex);
        CodeSearchTreemapBuilderBase.SearchHitData searchHitData = new CodeSearchTreemapBuilderBase.SearchHitData(this);
        this.searchHits.forEach(result -> searchHitData.incrementHitsForPath(result.getSource().getSourceName()));
        for (MetricDirectoryEntry entry : entries) {
            String cleanPath = UniformPathCompatibilityUtil.resolveToCodePath((String)entry.getUniformPath());
            int hitsForPath = searchHitData.hitsByPath.getValue((Object)cleanPath);
            searchHitData.updateDataForPath(hitsForPath, entry, locIndex);
        }
        return new FilteredTreeMapWrapper(searchHitData.affectedPaths, this.treemap, overallFiles, searchHitData.affectedLoc, searchHitData.affectedFiles, searchHitData.overallHits);
    }
}

