/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.search.ESearchTokenSourceType;
import com.teamscale.index.search.InvertedCodeSearchIndex;
import com.teamscale.index.search.SearchToken;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.metrics.schema.GlobalMetricSchemaService;
import com.teamscale.service.metrics.schema.MetricSchemaService;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.search.SearchAutocompletionService;
import com.teamscale.wia.TeamscaleIssueId;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public abstract class SearchServiceBase
extends ApiBase {
    private static final String SUGGESTION_QUERY_SEPARATOR = " \u2022 ";
    protected static final String FILE_SUGGESTION_QUERY_PREFIX = "file:";
    protected static final String REVISION_SUGGESTION_QUERY_PREFIX = "rev:";
    protected static final String ISSUE_SUGGESTION_QUERY_PREFIX = "issue:";
    protected @Nullable PublicProjectId project = null;

    private boolean isGlobalSearch() {
        return this.project == null;
    }

    protected List<PublicProjectId> getVisibleSearchedProjects() throws StorageException {
        if (this.isGlobalSearch()) {
            return ProjectUtils.resolveToPrimaryPublicId((List)this.getPermissions().getVisibleProjects());
        }
        this.getPermissions().checkProjectPermission((IProjectId)this.project, EProjectPermission.VIEW);
        return Collections.singletonList(this.project);
    }

    protected Set<SearchAutocompletionService.SearchSuggestion> determineFileSuggestions(String searchQuery, int numSuggestions, ProjectIndex projectIndex, boolean fileSearchOnlyPathMatches) throws StorageException {
        if (searchQuery.length() < 2 || !FileSystemUtils.isValidPath((String)searchQuery)) {
            return Collections.emptySet();
        }
        String parentPath = null;
        Path filePath = Paths.get(searchQuery, new String[0]);
        searchQuery = filePath.getFileName().toString();
        if (filePath.getParent() != null) {
            parentPath = filePath.getParent().toString();
        }
        HashSet<SearchAutocompletionService.SearchSuggestion> suggestions = new HashSet<SearchAutocompletionService.SearchSuggestion>();
        for (PublicProjectId projectId : this.getVisibleSearchedProjects()) {
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)projectId);
            InvertedCodeSearchIndex invertedSearchIndex = (InvertedCodeSearchIndex)this.getIndexLayer().openNonHistorizedProjectIndex(InvertedCodeSearchIndex.class, projectInfo);
            List tokens = invertedSearchIndex.getTokensByPrefix(searchQuery.toLowerCase(), numSuggestions);
            SearchServiceBase.convertSearchTokensToSuggestions(tokens, fileSearchOnlyPathMatches, projectId, suggestions);
            HistoryAccessOption historyAccessOption = HistoryAccessOption.readHead((String)this.getDefaultBranchName((IProjectId)projectInfo.getInternalId()));
            PathLookupIndex pathLookupIndex = (PathLookupIndex)this.getIndexLayer().openProjectIndex(projectInfo, PathLookupIndex.class, historyAccessOption);
            BasicTokenElementIndex tokenElementIndex = (BasicTokenElementIndex)this.getIndexLayer().openProjectIndex(projectInfo, BasicTokenElementIndex.class, historyAccessOption);
            List paths = pathLookupIndex.lookupByFileNamePart(searchQuery);
            for (String path : paths) {
                BasicTokenElementInfo elementInfo = tokenElementIndex.getTokenElement(path);
                if (elementInfo != null && elementInfo.getFirstDetailOfType(HiddenTokenElementDetail.class).isPresent()) continue;
                if (parentPath == null || path.contains(parentPath)) {
                    suggestions.add(SearchServiceBase.createFileSuggestion(projectId, path));
                }
                if (numSuggestions <= 0 || suggestions.size() < numSuggestions) continue;
                return suggestions;
            }
        }
        return suggestions;
    }

    private static void convertSearchTokensToSuggestions(List<SearchToken> tokens, boolean onlyPathMatches, PublicProjectId project, Set<SearchAutocompletionService.SearchSuggestion> suggestions) {
        for (SearchToken token : tokens) {
            if (token.getSourceType() == ESearchTokenSourceType.PATH) {
                suggestions.add(SearchServiceBase.createFileSuggestion(project, token.getSourceName()));
            }
            if (onlyPathMatches) continue;
            suggestions.add(new SearchAutocompletionService.SearchSuggestion(SearchAutocompletionService.ESearchSuggestionType.TOKEN, project, token.getText(), token.getText()));
        }
    }

    private static SearchAutocompletionService.SearchSuggestion createFileSuggestion(PublicProjectId project, String path) {
        return new SearchAutocompletionService.SearchSuggestion(SearchAutocompletionService.ESearchSuggestionType.FILE, project, path, FILE_SUGGESTION_QUERY_PREFIX + String.valueOf(project) + "/" + path);
    }

    protected Set<SearchAutocompletionService.SearchSuggestion> determineRevisionSuggestions(String searchQuery, int numSuggestions, ProjectIndex projectIndex) throws StorageException {
        if (searchQuery.length() < 2 || numSuggestions <= 0) {
            return Collections.emptySet();
        }
        HashSet<SearchAutocompletionService.SearchSuggestion> suggestions = new HashSet<SearchAutocompletionService.SearchSuggestion>();
        for (PublicProjectId projectId : this.getVisibleSearchedProjects()) {
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)projectId);
            RepositoryLogIndex index = (RepositoryLogIndex)this.getIndexLayer().openNonHistorizedProjectIndex(RepositoryLogIndex.class, projectInfo);
            List entries = index.getEntries(index.getOldestTimestamp(), index.getNewestTimestamp() + 1L);
            for (RepositoryLogEntryAggregate entry : entries) {
                String revision = entry.getRevision();
                if (StringUtils.startsWithIgnoreCase((String)revision, (String)searchQuery)) {
                    suggestions.add(new SearchAutocompletionService.SearchSuggestion(SearchAutocompletionService.ESearchSuggestionType.REVISION, projectId, revision, REVISION_SUGGESTION_QUERY_PREFIX + revision + SUGGESTION_QUERY_SEPARATOR + String.valueOf(projectId) + SUGGESTION_QUERY_SEPARATOR + entry.getPrimaryEntry().getConnectorIdentifier()));
                }
                if (suggestions.size() < numSuggestions) continue;
                return suggestions;
            }
        }
        return suggestions;
    }

    protected Set<SearchAutocompletionService.SearchSuggestion> determineIssueSuggestions(String searchQuery, int numSuggestions, ProjectIndex projectIndex) throws StorageException {
        if (searchQuery.length() < 2 || numSuggestions <= 0) {
            return Collections.emptySet();
        }
        HashSet<SearchAutocompletionService.SearchSuggestion> suggestions = new HashSet<SearchAutocompletionService.SearchSuggestion>();
        for (PublicProjectId projectId : this.getVisibleSearchedProjects()) {
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)projectId);
            IssueIndex index = (IssueIndex)this.getIndexLayer().openNonHistorizedProjectIndex(IssueIndex.class, projectInfo);
            List connectorIds = index.getAllConnectorIds();
            ArrayList issueIds = new ArrayList();
            for (String connectorId : connectorIds) {
                issueIds.addAll(index.getAllKeysStartingWith(connectorId, searchQuery));
            }
            for (TeamscaleIssueId issue : issueIds) {
                suggestions.add(new SearchAutocompletionService.SearchSuggestion(SearchAutocompletionService.ESearchSuggestionType.ISSUE, projectId, issue.getExternalId(), ISSUE_SUGGESTION_QUERY_PREFIX + String.valueOf(issue) + SUGGESTION_QUERY_SEPARATOR + String.valueOf(projectId)));
                if (suggestions.size() < numSuggestions) continue;
                return suggestions;
            }
        }
        return suggestions;
    }

    protected void setAreaAndColorIndex(TreemapQueryOptions treemapRequestOptions, UniformPath uniformPath, PublicProjectId project) throws StorageException {
        if (treemapRequestOptions.areaMetricIndex == -1) {
            int locIndex;
            MetricDirectorySchema schema;
            List allAnalysisProfiles = this.openGlobalIndex(AnalysisProfileIndex.class).getAllProfiles();
            if (project == null) {
                List<MetricDirectorySchema> schemas = GlobalMetricSchemaService.getMergedMetricDirectorySchemas(this.getGlobalStorageSystem(), this.getUser(), allAnalysisProfiles, List.of(uniformPath));
                schema = schemas.get(0);
            } else {
                schema = MetricSchemaService.getSchema(UniformPath.EType.CODE, this.getProjectStorageSystem((IProjectId)project), this.getGlobalStorageSystem(), this.getUser());
            }
            treemapRequestOptions.areaMetricIndex = locIndex = schema.getValuePosition("Lines of Code");
            treemapRequestOptions.colorMetricIndex = locIndex;
        }
    }
}

