/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.system.AnalysisProgressDescriptor;
import com.teamscale.service.system.AnalysisProgressServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/analysis-progress")
public class ProjectAnalysisProgressService
extends AnalysisProgressServiceBase {
    @GET
    @Operation(summary="Get project analysis progress", description="Retrieves the project specific analysis progress.", tags={"System", "Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<AnalysisProgressDescriptor> getProjectAnalysisProgress() throws StorageException {
        ProjectAnalysisProgressIndex progressIndex = this.openProjectIndex(ProjectAnalysisProgressIndex.class, null);
        RepositoryLogIndex logIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        return ProjectAnalysisProgressService.createProgressDescriptors(progressIndex, logIndex);
    }
}

