/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemInfoIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/system-info")
public class SystemInfoService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @Operation(summary="Get system information.", description="Returns system information.", tags={"System"})
    public List<SystemProcessInfo> getSystemInformation() throws StorageException {
        SystemInfoIndex index = this.openGlobalIndex(SystemInfoIndex.class);
        Map<String, List<SystemInfoFragmentBase>> byProcessId = index.getAllValidFragments().stream().collect(Collectors.groupingBy(SystemInfoFragmentBase::getProcessId));
        if (byProcessId.isEmpty()) {
            throw new InternalServerErrorException("Could not find any valid processes in the database, probably something went wrong with the system information library. Please have a look at the teamscale.log for further debugging.");
        }
        ArrayList<SystemProcessInfo> result = new ArrayList<SystemProcessInfo>();
        for (String processId : CollectionUtils.sort(byProcessId.keySet())) {
            result.add(new SystemProcessInfo(processId, byProcessId.get(processId)));
        }
        return result;
    }

    public static class SystemProcessInfo {
        @JsonProperty(value="processId")
        private final String processId;
        @JsonProperty(value="sections")
        private final List<SystemInfoSection> sections;

        private SystemProcessInfo(String processId, List<SystemInfoFragmentBase> fragments) {
            this.processId = processId;
            this.sections = CollectionUtils.map((Collection)CollectionUtils.sort(fragments, Comparator.comparing(SystemInfoFragmentBase::getFragmentOrder).thenComparing(SystemInfoFragmentBase::getFragmentCaption)), SystemInfoSection::new);
        }
    }

    public static class SystemInfoSection {
        @JsonProperty(value="caption")
        private final String caption;
        @JsonProperty(value="entries")
        private final List<SystemInfoEntry> entries;

        private SystemInfoSection(SystemInfoFragmentBase fragment) {
            this.caption = fragment.getFragmentCaption();
            this.entries = fragment.convertToKeyValuePairs();
        }
    }
}

