/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.performance;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.performance.PerformanceMetricsEntry;
import com.teamscale.core.runtime.api.performance.PerformanceMetricsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/performance-metrics-trend")
public class PerformanceMetricsTrendService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @Operation(summary="Get system performance metrics", description="Provides a trend of performance metrics of previous days.", tags={"System"}, responses={@ApiResponse(responseCode="400", description="max-seconds value is greater than the current epoch seconds.")})
    public List<PerformanceMetricsEntry> getPerformanceMetricsTrend(@Parameter(description="The count of seconds of trend data to include.", required=true) @QueryParam(value="max-seconds") int maxSeconds) throws StorageException {
        long startTime = System.currentTimeMillis() - (long)(maxSeconds * 1000);
        if (startTime <= 0L) {
            throw new BadRequestException("Requested too many seconds! Did you accidentally provide milliseconds?");
        }
        PerformanceMetricsIndex performanceMetricsIndex = this.openGlobalIndex(PerformanceMetricsIndex.class);
        return performanceMetricsIndex.getMetricsTrend(startTime);
    }
}

