/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.performance.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.system.performance.debug.PerformanceDataDownloadServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/system/performance/debug/state-changes.csv")
public class PerformanceAnalysisStateDownloadService
extends PerformanceDataDownloadServiceBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get timings of analysis state changes", description="Allows downloading timing of analysis state changes as CSV.", tags={"Debugging"})
    public Response getAnalysisStateChangeTiming() throws StorageException {
        String entity = this.createCsvContent();
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"performance-state-changes.csv");
    }

    private String createCsvContent() throws StorageException {
        PairList<PublicProjectId, PerformanceIndexBase> performanceIndexes = this.openPerformanceIndexes();
        StringBuilder builder = new StringBuilder();
        builder.append("Project;State;Timestamp;Readable Time\n");
        for (int i = 0; i < performanceIndexes.size(); ++i) {
            for (Map.Entry entry : ((PerformanceIndexBase)performanceIndexes.getSecond(i)).getStateChangeTimestamps().entrySet()) {
                builder.append(performanceIndexes.getFirst(i)).append(";");
                builder.append(entry.getKey()).append(";");
                builder.append(entry.getValue()).append(";");
                builder.append(DateTimeUtils.getUiFormattedDateString((long)((Long)entry.getValue()))).append(";");
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

