/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.scheduler.debug;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.BestAssignableJobFinder;
import com.teamscale.core.runtime.impl.scheduling.EJobSelectionMode;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.RateLimitingSupport;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.function.SupplierWithException;

@Path(value="api/projects/{project}/scheduler/debug/status")
public class DebugSchedulerStatusService
extends DebugDumpServiceBase {
    @GET
    @Operation(summary="Get a textual representation of the scheduler status for a single project.", description="Returns a textual representation of the scheduler status for a single project to help with debugging seemingly stuck scheduling.", tags={"Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public String getSchedulerStatus() throws StorageException {
        return this.getDebugDumpResults();
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        try {
            InternalProjectId projectId = this.serviceInfo.getInternalId();
            AnalysisProgressIndexBase progressIndex = AnalysisProgressIndexBase.open((IndexLayer)this.getIndexLayer(), (IProjectId)projectId);
            writer.println("Assigned Jobs:");
            AssignedJobs assignedJobs = new AssignedJobs(progressIndex);
            assignedJobs.getAllJobs().forEach(job -> writer.println("  " + job.getTriggerName() + ": " + String.valueOf(job.getSchedulingCommit())));
            writer.println();
            writer.println("Scheduled Jobs:");
            CommitDescriptorIndex commitDescriptorIndex = CommitDescriptorIndex.open((IndexLayer)this.getIndexLayer(), (IProjectId)projectId);
            TriggerCache triggerCache = new TriggerCache(projectId, this.getIndexLayer());
            JobQueue jobQueue = new JobQueue(progressIndex, commitDescriptorIndex, triggerCache, assignedJobs, new RateLimitingSupport());
            jobQueue.getAllJobs().forEach(job -> writer.println("  " + job.getTriggerName() + ": " + String.valueOf(job.getSchedulingCommit())));
            writer.println();
            writer.println("Pre-Announcements:");
            jobQueue.getFirstPreAnnouncedCommits().forEach(commit -> writer.println("  " + String.valueOf(commit)));
            writer.println();
            writer.println("Next Scheduled Job:");
            BestAssignableJobFinder jobFinder = new BestAssignableJobFinder(assignedJobs, jobQueue, triggerCache, commitDescriptorIndex, EJobSelectionMode.ALL_JOBS, DebugSchedulerStatusService.allAssignedJobsSupplier(this.getIndexLayer()));
            jobFinder.setTraceWriter(message -> writer.print(message.indent(2)));
            writer.println("  Result: " + String.valueOf(jobFinder.findBestAssignableJob()));
        }
        catch (TriggerCompilationException e) {
            writer.println("\n\nFurther output failed due to exception: ");
            e.printStackTrace(writer);
        }
    }

    private static SupplierWithException<Collection<JobDescriptor>, StorageException> allAssignedJobsSupplier(final IndexLayer indexLayer) {
        return new SupplierWithException<Collection<JobDescriptor>, StorageException>(){
            private Collection<JobDescriptor> retrieved = null;

            public Collection<JobDescriptor> get() throws StorageException {
                if (this.retrieved == null) {
                    this.retrieved = 1.getAllAssignedJobs(indexLayer);
                    CCSMAssert.isNotNull(this.retrieved);
                }
                return this.retrieved;
            }

            private static Set<JobDescriptor> getAllAssignedJobs(IndexLayer indexLayer2) throws StorageException {
                ArrayList assignedJobs = new ArrayList();
                ProjectIndex projectIndex = indexLayer2.openProjectIndex();
                for (InternalProjectId project : projectIndex.getAllInternalProjectIds()) {
                    AnalysisProgressIndexBase projectProgressIndex = AnalysisProgressIndexBase.open((IndexLayer)indexLayer2, (IProjectId)project);
                    Set allProjectJobs = new AssignedJobs(projectProgressIndex).getAllJobs();
                    assignedJobs.addAll(allProjectJobs);
                }
                return assignedJobs.stream().map(ScheduledJob::getJob).collect(Collectors.toSet());
            }
        };
    }
}

