/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.method_history;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.testgap.method_history.MethodHistoryEntriesWrapper;
import com.teamscale.service.testgap.method_history.MethodHistoryServiceBase;
import com.teamscale.service.testgap.method_history.UserResolvedMethodHistoryEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/tests/{testUniformPath}/executed-methods-changelog")
public class ChangelogMethodsExecutedByTestService
extends MethodHistoryServiceBase {
    @GET
    @Operation(summary="Get related changes to a test", description="Returns the commit history of commits that affected code tested by the test.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="400", description="The given path is not a test.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MethodHistoryEntriesWrapper getHistoryForChangedMethods(@PathParam(value="testUniformPath") UniformPath testUniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="baseline") UnresolvedCommitDescriptor startCommit, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="end") UnresolvedCommitDescriptor endCommit, @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider. If this parameter is omitted every partition will be taken.") @QueryParam(value="partitions") Set<String> partitions) throws StorageException {
        if (!testUniformPath.isTestExecutionPath()) {
            throw new BadRequestException("The given path is not a test execution.");
        }
        CommitDescriptor startCommitResolved = this.resolve(startCommit);
        CommitDescriptor endCommitResolved = this.resolve(endCommit);
        if (startCommitResolved.getTimestamp() >= endCommitResolved.getTimestamp()) {
            throw new BadRequestException("Invalid timeframe. Start commit must be earlier than end commit.");
        }
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(endCommit);
        this.repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        this.partitions = partitions == null || partitions.isEmpty() ? this.getAllPartitions(endCommitResolved.getBranchName()) : new ArrayList<String>(partitions);
        this.userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        this.initializeCrossAnnotator(Set.of());
        List<MethodLocation> testedMethods = this.getTestedMethods(testUniformPath, this.partitions, historyAccessOption);
        SortedSet<UserResolvedMethodHistoryEntry> entries = this.getMethodHistoryEntriesForMethodLocations(startCommitResolved, endCommitResolved, testedMethods);
        return new MethodHistoryEntriesWrapper(entries, this.crossAnnotationExecutionProjects, endCommitResolved.getTimestamp());
    }

    private List<MethodLocation> getTestedMethods(UniformPath uniformPath, Collection<String> partitions, HistoryAccessOption historyAccessOption) throws StorageException {
        CoverageUnitToMethodsMapIndex coverageIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        Set methodIds = coverageIndex.getMethodsCoveredBy(uniformPath, partitions);
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        return methodIdIndex.getMethodLocations((Collection)methodIds);
    }
}

