/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.method_history;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.service.testgap.method_history.EMethodChangeType;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MethodHistoryEntry
implements Comparable<MethodHistoryEntry> {
    protected static final String COMMIT_PROPERTY = "commit";
    protected static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    protected static final String AUTHOR_PROPERTY = "author";
    protected static final String MESSAGE_PROPERTY = "message";
    protected static final String REVISION_PROPERTY = "revision";
    protected static final String METHOD_CHANGE_TYPE_PROPERTY = "methodChangeType";
    protected static final String START_OFFSET_PROPERTY = "startOffset";
    protected static final String END_OFFSET_PROPERTY = "endOffset";
    protected static final String START_LINE_PROPERTY = "startLine";
    protected static final String END_LINE_PROPERTY = "endLine";
    protected static final String METHOD_NAME_PROPERTY = "methodName";
    protected static final String TEST_PARTITION_PROPERTY = "testPartition";
    protected static final String ORIGIN_PATH_PROPERTY = "originPath";
    protected static final String ORIGIN_METHOD_NAME_PROPERTY = "originMethodName";
    protected static final String CONNECTOR_IDENTIFIER_PROPERTY = "repositoryIdentifier";
    protected static final String TEST_ORIGIN_COMMIT_PROPERTY = "testOriginCommit";
    protected static final String EXTERN_BRANCH_METHOD_HISTORY_ENTRIES_PROPERTY = "externBranchMethodHistoryEntries";
    @JsonProperty(value="commit")
    private CommitDescriptor commit;
    @JsonProperty(value="uniformPath")
    public final UniformPath uniformPath;
    @JsonProperty(value="author")
    public final String author;
    @JsonProperty(value="message")
    public final String message;
    @JsonProperty(value="revision")
    public final String revision;
    @JsonProperty(value="methodChangeType")
    public final EMethodChangeType methodChangeType;
    @JsonProperty(value="startOffset")
    public final int startOffset;
    @JsonProperty(value="endOffset")
    public final int endOffset;
    @JsonProperty(value="startLine")
    public final int startLine;
    @JsonProperty(value="endLine")
    public final int endLine;
    @JsonProperty(value="methodName")
    public final String methodName;
    @JsonProperty(value="testPartition")
    public final @Nullable String testPartition;
    @JsonProperty(value="originPath")
    public final @Nullable String originPath;
    @JsonProperty(value="originMethodName")
    public final @Nullable String originMethodName;
    @JsonProperty(value="testOriginCommit")
    public final @Nullable CommitDescriptor testOriginCommit;
    @JsonProperty(value="repositoryIdentifier")
    public final String connectorIdentifier;
    @JsonProperty(value="externBranchMethodHistoryEntries")
    public final List<MethodHistoryEntry> externBranchMethodHistoryEntries;

    public MethodHistoryEntry(CommitDescriptor commit, UniformPath uniformPath, OffsetBasedRegion region, int startLine, int endLine, String methodName, RepositoryLogEntry repositoryLog, EMethodChangeType methodChangeType, String originPath, String originMethodName, String testPartition, CommitDescriptor testOriginCommit, List<MethodHistoryEntry> externBranchMethodHistoryEntries) {
        this.commit = commit;
        this.uniformPath = uniformPath;
        this.startLine = startLine;
        this.endLine = endLine;
        this.methodName = methodName;
        this.author = repositoryLog.getAuthor();
        this.message = repositoryLog.getMessage();
        this.revision = repositoryLog.getRevision();
        this.connectorIdentifier = repositoryLog.getConnectorIdentifier();
        this.methodChangeType = methodChangeType;
        this.startOffset = region.getStart();
        this.endOffset = region.getEnd();
        this.originPath = originPath;
        this.originMethodName = originMethodName;
        this.testPartition = testPartition;
        this.testOriginCommit = testOriginCommit;
        this.externBranchMethodHistoryEntries = externBranchMethodHistoryEntries;
    }

    @JsonCreator
    public MethodHistoryEntry(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="uniformPath") UniformPath uniformPath, @JsonProperty(value="startOffset") int startOffset, @JsonProperty(value="endOffset") int endOffset, @JsonProperty(value="startLine") int startLine, @JsonProperty(value="endLine") int endLine, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="author") String author, @JsonProperty(value="message") String message, @JsonProperty(value="revision") String revision, @JsonProperty(value="repositoryIdentifier") String connectorIdentifier, @JsonProperty(value="methodChangeType") EMethodChangeType methodChangeType, @JsonProperty(value="originPath") String originPath, @JsonProperty(value="originMethodName") String originMethodName, @JsonProperty(value="testPartition") String testPartition, @JsonProperty(value="testOriginCommit") CommitDescriptor testOriginCommit, @JsonProperty(value="externBranchMethodHistoryEntries") List<MethodHistoryEntry> externBranchMethodHistoryEntries) {
        this.commit = commit;
        this.uniformPath = uniformPath;
        this.startLine = startLine;
        this.endLine = endLine;
        this.methodName = methodName;
        this.author = author;
        this.message = message;
        this.revision = revision;
        this.connectorIdentifier = connectorIdentifier;
        this.methodChangeType = methodChangeType;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.originPath = originPath;
        this.originMethodName = originMethodName;
        this.testPartition = testPartition;
        this.testOriginCommit = testOriginCommit;
        this.externBranchMethodHistoryEntries = externBranchMethodHistoryEntries;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public boolean isEntryAddressingChange() {
        return this.methodChangeType == EMethodChangeType.ADDED || this.methodChangeType == EMethodChangeType.MODIFIED;
    }

    public String toString() {
        return String.valueOf(this.commit) + " " + String.valueOf(this.uniformPath) + "#" + this.methodName + " " + String.valueOf((Object)this.methodChangeType);
    }

    public EMethodChangeType getMethodChangeType() {
        return this.methodChangeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodHistoryEntry that = (MethodHistoryEntry)o;
        return Objects.equals(this.commit, that.commit) && this.methodChangeType == that.methodChangeType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commit, this.methodChangeType});
    }

    @Override
    public int compareTo(@NonNull MethodHistoryEntry other) {
        int commitComparison = this.commit.compareTo(other.getCommit());
        if (commitComparison != 0) {
            return commitComparison;
        }
        return this.methodChangeType.compareTo(other.methodChangeType);
    }
}

