/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaPathRequest;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.MethodIdMap;
import com.teamscale.index.testimpact.PrioritizedTestListIndex;
import com.teamscale.index.testimpact.SelectedTest;
import com.teamscale.index.testimpact.TestListDescriptor;
import com.teamscale.index.testimpact.TestListIndex;
import com.teamscale.index.testimpact.TestMinimizationJobOptionsIndex;
import com.teamscale.index.testimpact.TestMinimizationJobRun;
import com.teamscale.index.testimpact.TestMinimizationJobsIndex;
import com.teamscale.index.testimpact.TestMinimizationRequestOptions;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestHistoryEntry;
import com.teamscale.index.tests.TestHistoryIndex;
import com.teamscale.index.utils.AsyncServiceJobRun;
import com.teamscale.service.IteratorStreaming;
import com.teamscale.service.PaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.testimpact.IAsyncTestMinimizationServiceApi;
import com.teamscale.service.testimpact.ImpactedTestUtils;
import com.teamscale.service.testimpact.TestMinimizationTrigger;
import com.teamscale.service.testimpact.TestReductionApiBase;
import com.teamscale.service.testimpact.TestSelectionStorageUtils;
import com.teamscale.service.testimpact.TiaDataRetrieverOptions;
import com.teamscale.service.tests.TestQueryUtils;
import com.teamscale.wia.TeamscaleIssueId;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.StorageIterator;
import org.conqat.engine.persistence.store.StorageIterators;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/minimized-tests")
public class AsyncTestMinimizationService
extends TestReductionApiBase
implements IAsyncTestMinimizationServiceApi {
    @Override
    public String setupJob(TestMinimizationRequestOptions testMinimizationRequestOptions) throws StorageException {
        TestMinimizationJobsIndex jobsIndex = this.openJobsIndex();
        TestMinimizationJobOptionsIndex jobOptionsIndex = this.openJobOptionsIndex();
        TestMinimizationJobRun job = new TestMinimizationJobRun(this.getUser().getUsername(), DateTimeUtils.getClock().millis(), "");
        jobOptionsIndex.setJobOptions(job.getId(), testMinimizationRequestOptions);
        jobsIndex.setJob(job.getId(), job);
        return job.getId();
    }

    @Override
    public void updateJobOptions(String jobId, TestMinimizationRequestOptions testMinimizationRequestOptions) throws StorageException {
        TestMinimizationJobRun job = this.getTestMinimizationJobStatus(jobId);
        if (!job.getUsername().equals(this.getUser().getUsername())) {
            throw new ForbiddenException("Insufficient permissions to update job. The job was created by another user.");
        }
        this.openJobsIndex().setJob(jobId, job.withStartTimestamp(DateTimeUtils.getClock().millis()));
        this.openJobOptionsIndex().setJobOptions(jobId, testMinimizationRequestOptions);
    }

    @Override
    public void startJob(String jobId) throws StorageException {
        TestMinimizationJobRun job = this.getTestMinimizationJobStatus(jobId);
        this.openJobsIndex().setJob(jobId, job.withJobStatus(AsyncServiceJobRun.EJobStatus.SCHEDULED).withStartTimestamp(DateTimeUtils.getClock().millis()));
        JobDescriptor jobDescriptor = JobDescriptor.forProject((InternalProjectId)this.serviceInfo.getInternalId()).withPrivilegedTrigger(TestMinimizationTrigger.class).withSchedulingReason("Scheduled through the AsyncTestMinimizationService by the user '" + this.getUser().getUsername() + "'.").withParameter(job.getId()).build();
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), jobDescriptor);
    }

    @Override
    public int postJobTests(String jobId, List<String> testPaths) throws StorageException {
        TestMinimizationRequestOptions jobOptions = this.getJobOptions(jobId);
        @NonNull CommitDescriptor resolvedCommit = this.resolve(jobOptions.getEndCommit());
        TestHistoryIndex testHistoryIndex = this.openTestHistoryIndex(resolvedCommit);
        ExecutionUnitIndex executionUnitIndex = this.openExecutionUnitIndex(resolvedCommit);
        return this.appendTests(jobId, AsyncTestMinimizationService.toSelectedTests(executionUnitIndex, testHistoryIndex.getByIds(testPaths))).addedTests();
    }

    private PrioritizedTestListIndex.TestListDeltaSummary appendTests(String jobId, List<SelectedTest> toAppend) throws StorageException {
        TestMinimizationJobRun job = this.getTestMinimizationJobStatus(jobId);
        return TestSelectionStorageUtils.appendTests(job, this.openJobsIndex(), this.openTestResultsIndex(), toAppend);
    }

    private static List<SelectedTest> toSelectedTests(ExecutionUnitIndex executionUnitIndex, List<TestHistoryEntry> entries) throws StorageException {
        ArrayList<SelectedTest> result = new ArrayList<SelectedTest>();
        ArrayList testExecutionUnitPaths = new ArrayList();
        for (TestHistoryEntry entry : entries) {
            String executionUnit = entry.getExecutionUnitUniformPath();
            if (executionUnit == null) {
                result.addAll(AsyncTestMinimizationService.testHistoryEntryToSelectedTest(entry));
                continue;
            }
            entry.getPartitions().forEach(partition -> testExecutionUnitPaths.add(new PartitionAndPath(partition, entry.getExecutionUnitUniformPath())));
        }
        List executionUnits = executionUnitIndex.getExecutionUnits(testExecutionUnitPaths);
        for (int i = 0; i < testExecutionUnitPaths.size(); ++i) {
            PartitionAndPath partitionAndPath = (PartitionAndPath)testExecutionUnitPaths.get(i);
            ExecutionUnit executionUnit = (ExecutionUnit)executionUnits.get(i);
            if (executionUnit == null) {
                throw new StorageException(String.format("Execution unit with id '%s' not found!", partitionAndPath));
            }
            result.add(SelectedTest.withoutRanking((String)partitionAndPath.getUniformPath(), (String)partitionAndPath.getPartition(), (Long)Optional.ofNullable(executionUnit.getDurationSeconds()).map(duration -> (long)(duration * 1000.0)).orElse(0L)));
        }
        return result;
    }

    private static List<SelectedTest> testHistoryEntryToSelectedTest(TestHistoryEntry entry) {
        ArrayList<SelectedTest> result = new ArrayList<SelectedTest>();
        if (entry.getPartitions().isEmpty()) {
            result.add(SelectedTest.withoutRanking((String)entry.getUniformPath(), null, (Long)0L));
        } else {
            for (String partition : entry.getPartitions()) {
                result.add(SelectedTest.withoutRanking((String)entry.getUniformPath(), (String)partition, (Long)((Long)entry.getDurations().get(partition))));
            }
        }
        return result;
    }

    @Override
    public int deleteJobTests(String jobId, Set<Integer> testRankings, IAsyncTestMinimizationServiceApi.EDeleteMode deleteMode) throws StorageException {
        TestMinimizationJobRun job = this.getTestMinimizationJobStatus(jobId);
        PrioritizedTestListIndex jobRankingResultIndex = this.openTestResultsIndex();
        if (deleteMode == IAsyncTestMinimizationServiceApi.EDeleteMode.ALL) {
            if (testRankings.isEmpty()) {
                jobRankingResultIndex.clearRankingResult(jobId);
                int oldTestCount = job.getTestCount();
                this.openJobsIndex().setJob(jobId, job.withTestCount(0).withTestDuration(0L).withTestListHash(""));
                return oldTestCount;
            }
            throw new IllegalArgumentException("This case is not yet supported.");
        }
        if (deleteMode == IAsyncTestMinimizationServiceApi.EDeleteMode.ONLY_GIVEN) {
            PrioritizedTestListIndex.TestListDeltaSummary delta = jobRankingResultIndex.deleteTestsWithRanking(jobId, testRankings);
            this.openJobsIndex().setJob(jobId, job.withTestCount(delta.totalTests()).withTestListHash(delta.testListHash()).withTestDuration(delta.totalDurationMs()));
            return delta.removedTests();
        }
        throw new IllegalArgumentException("Unsupported delete mode given as argument!");
    }

    @Override
    public int putJobTestsFromQuery(String jobId, String query, boolean onlyWithCoverage) throws StorageException, QueryCompilationException, QueryParsingException {
        TestMinimizationRequestOptions jobOptions = this.getJobOptions(jobId);
        CommitDescriptor resolvedCommit = this.resolve(jobOptions.getEndCommit());
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
        ExecutionUnitIndex executionUnitIndex = this.openProjectIndex(ExecutionUnitIndex.class, historyAccessOption);
        List<TestHistoryEntry> testHistoryEntries = TestQueryUtils.getTestHistoryEntries(query, onlyWithCoverage, true, resolvedCommit, this.serviceInfo);
        List<SelectedTest> tests = AsyncTestMinimizationService.toSelectedTests(executionUnitIndex, testHistoryEntries);
        return this.appendTests(jobId, tests).addedTests();
    }

    @Override
    public int putJobTestsFromImpacted(String jobId, TiaRequestOptions tiaRequestOptions, List<String> crossAnnotationProjectPatterns, boolean onlyTestGaps) throws StorageException, InterruptedException {
        this.checkJobStillPresent(jobId);
        TiaDataRetrieverOptions tiaDataRetrieverOptions = TiaDataRetrieverOptions.create(tiaRequestOptions, this.serviceInfo.getInternalId(), this.getUser(), this.getIndexLayer());
        TgaCoverageSourceQueryParameters coverageParameters = tiaRequestOptions.getPartitionInfo().toCoverageSourceQueryParameters(crossAnnotationProjectPatterns);
        TimeIntervalBasedServiceQueryOptions timeIntervalParameters = new TimeIntervalBasedServiceQueryOptions(tiaDataRetrieverOptions.getEndCommit().toUnresolvedCommitDescriptor(), tiaDataRetrieverOptions.getBaselineCommit().toUnresolvedCommitDescriptor());
        TgaRequestQueryOptions requestOptions = new TgaRequestQueryOptions(false, null, false, (UniformPath)UniformPath.codeRoot(), null);
        ETgaAssessmentType assessmentType = ETgaAssessmentType.TEST_GAP;
        if (!onlyTestGaps) {
            assessmentType = ETgaAssessmentType.CHURN;
        }
        TgaPathRequest request = TgaPathRequest.createRequest((ITgaCoverageSourceParameter)coverageParameters, (TimeIntervalBasedServiceQueryOptions)timeIntervalParameters, (TgaRequestQueryOptions)requestOptions, (ETgaAssessmentType)assessmentType, (IndexLayer)this.serviceInfo.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId());
        List<MethodLocation> assessedMethods = request.fetchAndAssessData().getChangedMethods(onlyTestGaps).stream().map(AssessedTgaData.AssessedMethodData::getLocation).toList();
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(tiaDataRetrieverOptions.getEndCommit().toUnresolvedCommitDescriptor());
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        Set<MethodId> methodsToCover = methodIdIndex.getMethodIds(assessedMethods).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        List<PartitionAndPath> coveringTests = ImpactedTestUtils.getAllTestsCovering(tiaRequestOptions, this.serviceInfo, methodsToCover);
        return this.appendPartitionAndPaths(jobId, coveringTests).addedTests();
    }

    @Override
    public TestMinimizationJobRun getTestMinimizationJobStatus(String jobId) throws StorageException {
        TestMinimizationJobRun result = this.openJobsIndex().getJobWithId(jobId);
        if (result == null) {
            throw new NotFoundException(String.format("The queried job %s does no longer exist.", jobId));
        }
        return result;
    }

    @Override
    public TestMinimizationRequestOptions getJobOptions(String jobId) throws StorageException {
        TestMinimizationRequestOptions result = this.openJobOptionsIndex().getJobOptionsFor(jobId);
        if (result == null) {
            throw new NotFoundException(String.format("The queried job options %s do no longer exist.", jobId));
        }
        return result;
    }

    @Override
    public List<TestMinimizationJobRun> getJobs() throws StorageException {
        return this.openJobsIndex().getAllJobs().extractSecondList().stream().filter(job -> job.getUsername().equals(this.getUser().getUsername())).collect(Collectors.toList());
    }

    @Override
    @RequiresProjectPermission(value={EProjectPermission.TEST_SELECTION_RANKING})
    public void stopAndDeleteMinimizationJob(String jobId) throws StorageException {
        this.checkJobStillPresent(jobId);
        this.openJobsIndex().removeJob(jobId);
        this.openJobOptionsIndex().removeJobOptions(jobId);
        this.openTestResultsIndex().clearRankingResult(jobId);
    }

    @Override
    public PairList<MethodLocation, PairList<Long, Set<TeamscaleIssueId>>> getRisks(UniformPath uniformPath, TgaCoverageSourceQueryParameters coverageSourceParameters, @Nullable UnresolvedCommitDescriptor baselineCommit, UnresolvedCommitDescriptor endCommit, boolean onlyTestGaps, @Nullable String issueQuery) throws StorageException {
        Map<MethodLocation, Map<Long, Set<TeamscaleIssueId>>> risksBasedOnChangesSince = this.selectRisksBasedOnChangesSince(uniformPath, baselineCommit, endCommit, onlyTestGaps, coverageSourceParameters);
        Map<MethodLocation, Map<Long, Set<TeamscaleIssueId>>> risksBasedOnIssues = this.selectRisksBasedOnIssues(uniformPath, issueQuery, endCommit);
        HashSet<MethodLocation> allMethods = new HashSet<MethodLocation>();
        allMethods.addAll(risksBasedOnChangesSince.keySet());
        allMethods.addAll(risksBasedOnIssues.keySet());
        PairList result = new PairList();
        for (MethodLocation method : allMethods) {
            Map<Long, Set<TeamscaleIssueId>> issueBasedRisks = risksBasedOnIssues.getOrDefault(method, Collections.emptyMap());
            Map<Long, Set<TeamscaleIssueId>> baselineBasedRisks = risksBasedOnChangesSince.getOrDefault(method, Collections.emptyMap());
            result.add((Object)method, AsyncTestMinimizationService.mergeRisksSinceMaps(issueBasedRisks, baselineBasedRisks));
        }
        return result;
    }

    private static PairList<Long, Set<TeamscaleIssueId>> mergeRisksSinceMaps(Map<Long, Set<TeamscaleIssueId>> risks1, Map<Long, Set<TeamscaleIssueId>> risks2) {
        HashMap<Long, Set<TeamscaleIssueId>> methodRiskExplanation = new HashMap<Long, Set<TeamscaleIssueId>>(risks1);
        for (Map.Entry<Long, Set<TeamscaleIssueId>> baselineEntry : risks2.entrySet()) {
            methodRiskExplanation.merge(baselineEntry.getKey(), baselineEntry.getValue(), (x$0, xva$1) -> CollectionUtils.unionSet((Collection)x$0, (Collection[])new Collection[]{xva$1}));
        }
        return PairList.fromMap(methodRiskExplanation);
    }

    private Map<MethodLocation, Map<Long, Set<TeamscaleIssueId>>> selectRisksBasedOnChangesSince(UniformPath uniformPath, @Nullable UnresolvedCommitDescriptor baselineCommit, UnresolvedCommitDescriptor endCommit, boolean onlyTestGaps, TgaCoverageSourceQueryParameters coverageSourceParameters) throws StorageException {
        if (baselineCommit == null || baselineCommit.equals((Object)UnresolvedCommitDescriptor.DEFAULT_HEAD)) {
            return Map.of();
        }
        TgaRequestQueryOptions tgaRequestParameters = new TgaRequestQueryOptions(false, null, false, uniformPath, null);
        ETgaAssessmentType assessmentType = ETgaAssessmentType.TEST_GAP;
        if (!onlyTestGaps) {
            assessmentType = ETgaAssessmentType.CHURN;
        }
        TgaPathRequest request = TgaPathRequest.createRequest((ITgaCoverageSourceParameter)coverageSourceParameters, (TimeIntervalBasedServiceQueryOptions)new TimeIntervalBasedServiceQueryOptions(endCommit, baselineCommit), (TgaRequestQueryOptions)tgaRequestParameters, (ETgaAssessmentType)assessmentType, (IndexLayer)this.serviceInfo.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId());
        List assessedMethods = request.fetchAndAssessData().getChangedMethods(true);
        HashMap<MethodLocation, Map<Long, Set<TeamscaleIssueId>>> result = HashMap.newHashMap(assessedMethods.size());
        assessedMethods.forEach(method -> result.put(method.getLocation(), Map.of(method.getLastChangeTimestamp(), AsyncTestMinimizationService.singletonSetIfNotNull(method.getLastChangedInIssueId()))));
        return result;
    }

    private static <T> Set<T> singletonSetIfNotNull(@Nullable T element) {
        if (element == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(element);
    }

    private Map<MethodLocation, Map<Long, Set<TeamscaleIssueId>>> selectRisksBasedOnIssues(UniformPath uniformPath, String issueQuery, UnresolvedCommitDescriptor endCommit) throws StorageException {
        if (StringUtils.isEmpty((String)issueQuery)) {
            return Map.of();
        }
        HistoryAccessOption historyAtEndCommit = this.determineHistoryOption(endCommit);
        IssueHistoryIndex issueHistoryIndex = this.openProjectIndex(IssueHistoryIndex.class, null);
        CommitResolvingStorageSystem projectStorageSystem = this.serviceInfo.getProjectStorageSystem();
        QueryableEntityUtils.QueryContext queryContext = QueryableEntityUtils.QueryContext.ofTimestamp((ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem(), (User)this.serviceInfo.getUser(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.ISSUE, (HistoryAccessOption)historyAtEndCommit);
        List<TeamscaleIssueId> issueIds = AsyncTestMinimizationService.getIssueIds(issueQuery, issueHistoryIndex, queryContext);
        MethodIssueIndex methodIssueIndex = this.openProjectIndex(MethodIssueIndex.class, historyAtEndCommit);
        List changedByIssues = methodIssueIndex.getMappingsForIssueIds(issueIds);
        return this.selectRisksBasedOnIssues(uniformPath, historyAtEndCommit, (PairList<TeamscaleIssueId, Map<MethodLocation, Long>>)PairList.zip(issueIds, (List)changedByIssues));
    }

    private @NonNull Map<MethodLocation, Map<Long, Set<TeamscaleIssueId>>> selectRisksBasedOnIssues(UniformPath uniformPath, HistoryAccessOption historyAccessOption, PairList<TeamscaleIssueId, Map<MethodLocation, Long>> issuesWithChanges) throws StorageException {
        VirtualCodePathUtils.IVirtualPathLookup virtualPathResolver = VirtualCodePathUtils.getVirtualPathLookup((UniformPath)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        HashMap<MethodLocation, Map<Long, Set<TeamscaleIssueId>>> result = new HashMap<MethodLocation, Map<Long, Set<TeamscaleIssueId>>>();
        for (Pair entry : issuesWithChanges) {
            TeamscaleIssueId issueId = (TeamscaleIssueId)entry.getFirst();
            Map methodsChangedByIssueAt = (Map)entry.getSecond();
            for (Map.Entry methodEntry : methodsChangedByIssueAt.entrySet()) {
                MethodLocation methodLocation = (MethodLocation)methodEntry.getKey();
                Optional resolvedPath = virtualPathResolver.lookupVirtualPath(methodLocation.getUniformPath());
                if (resolvedPath.isEmpty()) continue;
                methodLocation = new MethodLocation((UniformPath)resolvedPath.get(), methodLocation.getRegion());
                Map methodChanges = result.computeIfAbsent(methodLocation, k -> new HashMap());
                Set methodChangesAt = methodChanges.computeIfAbsent((Long)methodEntry.getValue(), k -> new HashSet());
                methodChangesAt.add(issueId);
            }
        }
        return result;
    }

    private static List<TeamscaleIssueId> getIssueIds(String issueQuery, IssueHistoryIndex issueHistoryIndex, QueryableEntityUtils.QueryContext queryContext) throws StorageException {
        try {
            return QueryableEntityUtils.performQueryWithEmptyHandling((String)issueQuery, (IKeyedObjectIndex)issueHistoryIndex, (QueryableEntityUtils.QueryContext)queryContext).stream().map(TeamscaleIssueId::fromInternalId).toList();
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new BadRequestException("Could not process query: " + e.getMessage(), e);
        }
    }

    @Override
    public int saveAsNamedTestList(String jobId, String testListName) throws StorageException {
        this.checkJobStillPresent(jobId);
        PrioritizedTestListIndex jobsIndex = this.openTestResultsIndex();
        List<PartitionAndPath> jobTests = jobsIndex.getTestList(jobId).stream().map(SelectedTest::toPartitionAndPath).toList();
        this.openTestListsIndex().storeTestList(new TestListDescriptor(testListName, jobTests));
        return jobTests.size();
    }

    @Override
    public int loadFromNamedTestList(String jobId, String testListName, boolean replaceTests) throws StorageException {
        TestListDescriptor toAppend;
        this.checkJobStillPresent(jobId);
        PrioritizedTestListIndex testResultsIndex = this.openTestResultsIndex();
        if (replaceTests) {
            testResultsIndex.clearRankingResult(jobId);
        }
        if ((toAppend = this.openTestListsIndex().getTestList(testListName)) == null) {
            throw new NotFoundException("Test list with given name not found!");
        }
        return this.appendPartitionAndPaths(jobId, toAppend.getList()).addedTests();
    }

    private PrioritizedTestListIndex.TestListDeltaSummary appendPartitionAndPaths(String jobId, List<PartitionAndPath> toAppend) throws StorageException {
        TestMinimizationJobRun job = this.getTestMinimizationJobStatus(jobId);
        TestMinimizationRequestOptions jobOptions = this.getJobOptions(jobId);
        PrioritizedTestListIndex testResultsIndex = this.openTestResultsIndex();
        HistoryAccessOption historyOption = this.determineHistoryOption(jobOptions.getEndCommit());
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyOption);
        ExecutionUnitIndex executionUnitIndex = this.openProjectIndex(ExecutionUnitIndex.class, historyOption);
        return TestSelectionStorageUtils.appendPartitionAndPaths(job, this.openJobsIndex(), testResultsIndex, testExecutionIndex, executionUnitIndex, toAppend);
    }

    @Override
    public List<SelectedTest> getSelectedTests(String jobId, PaginationOptions paginationOptions) throws StorageException {
        return StorageIterators.extractSubList(this.iterateSelectedTests(jobId), (int)paginationOptions.getStartIndex(), (int)paginationOptions.getMaxResults());
    }

    private StorageIterator<SelectedTest, StorageException> iterateSelectedTests(String jobId) throws StorageException {
        this.checkJobStillPresent(jobId);
        return StorageIterators.mapSequentially(this.buildAdditionallyCoveredIterator(jobId), pair -> {
            SelectedTest result = (SelectedTest)pair.getFirst();
            return SelectedTest.withAdditionallyCoveredMethods((SelectedTest)result, (int)((Set)pair.getSecond()).size());
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public Response downloadTestSelectionCsv(String jobId, long timeBudgetMillis) throws StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private @NonNull StorageIterator<SelectedTest, StorageException> buildTimeLimitedTestsIterator(String jobId, long timeBudgetMillis) throws StorageException {
        return StorageIterators.filterOnReduce(this.iterateSelectedTests(jobId), (Object)timeBudgetMillis, (test, remainingMillis) -> new StorageIterators.ReductionFilterResult((remainingMillis = Long.valueOf(remainingMillis - test.durationInMs())) >= 0L, remainingMillis), remainingMillis -> remainingMillis <= 0L);
    }

    @Override
    public Response getAdditionallyCoveredMethods(String jobId) throws StorageException {
        return Response.ok((Object)IteratorStreaming.createJsonStreamFromStorageIterator(StorageIterators.mapSequentially(this.buildAdditionallyCoveredIterator(jobId), ImmutablePair::getSecond))).build();
    }

    private @NonNull StorageIterator<Pair<SelectedTest, Set<MethodLocation>>, StorageException> buildAdditionallyCoveredIterator(String jobId) throws StorageException {
        TestMinimizationRequestOptions jobOptions = this.getJobOptions(jobId);
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(jobOptions.getEndCommit());
        PrioritizedTestListIndex jobsIndex = this.openTestResultsIndex();
        CoverageUnitToMethodsMapIndex testsToMethodsMapIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        Predicate pathContainmentChecker = VirtualCodePathUtils.includedInResolvedTree((UniformPath)jobOptions.getCoveringPath(), (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        MethodIdMap allMappings = methodIdIndex.getMappingsForAllPaths();
        HashSet alreadyCovered = new HashSet();
        return StorageIterators.mapSequentially((StorageIterator)jobsIndex.listIterator(jobId), prioritizableTest -> {
            HashSet<MethodLocation> testCoversAdditionally = new HashSet<MethodLocation>();
            Set methodsCoveredBy = ((Set)testsToMethodsMapIndex.getMethodsCoveredBy(Collections.singletonList(prioritizableTest.toPartitionAndPath())).getFirst()).stream().filter(methodId -> pathContainmentChecker.test(methodId.getUniformPath())).collect(Collectors.toSet());
            for (MethodId method : methodsCoveredBy) {
                if (!alreadyCovered.add(method)) continue;
                testCoversAdditionally.add(allMappings.getMethodLocation(method));
            }
            return Pair.createPair((Object)prioritizableTest, testCoversAdditionally);
        });
    }

    private PrioritizedTestListIndex openTestResultsIndex() throws StorageException {
        return this.openProjectIndex(PrioritizedTestListIndex.class, null);
    }

    private TestMinimizationJobOptionsIndex openJobOptionsIndex() throws StorageException {
        return this.openProjectIndex(TestMinimizationJobOptionsIndex.class, null);
    }

    private TestMinimizationJobsIndex openJobsIndex() throws StorageException {
        return this.openProjectIndex(TestMinimizationJobsIndex.class, null);
    }

    private TestListIndex openTestListsIndex() throws StorageException {
        return this.openProjectIndex(TestListIndex.class, null);
    }

    private TestHistoryIndex openTestHistoryIndex(CommitDescriptor resolvedCommit) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
        return this.openProjectIndex(TestHistoryIndex.class, historyAccessOption);
    }

    private ExecutionUnitIndex openExecutionUnitIndex(CommitDescriptor resolvedCommit) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
        return this.openProjectIndex(ExecutionUnitIndex.class, historyAccessOption);
    }

    private void checkJobStillPresent(String jobId) throws StorageException {
        if (this.openJobOptionsIndex().getJobOptionsFor(jobId) == null) {
            throw new NotFoundException(String.format("The queried job %s does no longer exist.", jobId));
        }
    }
}

