/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.logging.UncriticalStatusCode;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TestWithClusterId;

public interface ITestImpactServiceApi {
    public static final String GENERIC_DESCRIPTION = "Returns an ordered list of test clusters that are impacted by the given changes.";
    public static final String GET_DESCRIPTION = "Returns an ordered list of test clusters that are impacted by the given changes. The returned flat list of tests is a subset of all tests known to Teamscale. When the tests themselves have changed, new tests were added or tests have been deleted, this service cannot take that into account. Please use the PUT endpoint instead to provide a list of available tests. In particular, this endpoint may return tests that no longer exist. Callers must handle this case.";
    public static final String PUT_DESCRIPTION = "Returns an ordered list of test clusters that are impacted by the given changes. The returned list of test clusters is a subset of the tests given in the request body. Clusters of selected and prioritized tests are formed based on the clustering information given in the request body. The tests from the request body are furthermore used to determine if any tests have changed or new tests were added. These are always included in the returned list of impacted tests.";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get impacted tests", description="Returns an ordered list of test clusters that are impacted by the given changes. The returned flat list of tests is a subset of all tests known to Teamscale. When the tests themselves have changed, new tests were added or tests have been deleted, this service cannot take that into account. Please use the PUT endpoint instead to provide a list of available tests. In particular, this endpoint may return tests that no longer exist. Callers must handle this case.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    @UncriticalStatusCode(value=Response.Status.PRECONDITION_FAILED)
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0)
    public List<PrioritizableTest> getImpactedTests(@BeanParam TiaRequestOptions var1) throws StorageException, InterruptedException;

    @PUT
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Get impacted tests", description="Returns an ordered list of test clusters that are impacted by the given changes. The returned list of test clusters is a subset of the tests given in the request body. Clusters of selected and prioritized tests are formed based on the clustering information given in the request body. The tests from the request body are furthermore used to determine if any tests have changed or new tests were added. These are always included in the returned list of impacted tests.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    @UncriticalStatusCode(value=Response.Status.PRECONDITION_FAILED)
    @PublicApi(since=ETeamscaleVersion.VERSION_9_4_0)
    public List<PrioritizableTestCluster> getImpactedTestsFromAvailableTests(@BeanParam TiaRequestOptions var1, @RequestBody List<TestWithClusterId> var2) throws StorageException, InterruptedException;
}

