/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.external.input.LoadAndIntegrateSapTestwiseCoverageTrigger;
import com.teamscale.index.repository.sap.abapsystem.importer.SapTestwiseCoverageCommunicator;
import com.teamscale.index.testimpact.ManualSapTestInfo;
import com.teamscale.index.testimpact.TemporarySapTestInfoIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testimpact.SapTestEventListenerServiceQueryOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/sap-test-event")
public class SapTestEventListenerService
extends ApiBase {
    private static final String TEST_ALREADY_RUNNING_ERROR_MESSAGE = "One SAP user can not run more than one SAP test per project at once. If this is not expected, use api/projects/{project}/sap-test-event/reset/{sap-user} to reset the state stored in Teamscale. There is already a test running for user ";
    private static final String PREFIX_FORWARDED_ANSWER_OF_SAP_SERVER = "SAP server returned: ";
    private static final String PREFIX_OF_SAP_SERVER_IN_CASE_OF_ERROR = "Error";
    private static final DateTimeFormatter FILE_NAME_DATE_TIME_FORMATTER = DateTimeUtils.createDateTimeFormatter((String)"yyyy-MM-dd_HHmmss");

    @POST
    @Path(value="start")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Start SAP coverage recording", description="Starts the user specific coverage recording on a SAP system for the given SAP user.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="409", description="Can not start coverage recording for the given SAP user.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    public String startTest(@BeanParam SapTestEventListenerServiceQueryOptions parameters) throws BadRequestException, ConQATException {
        TemporarySapTestInfoIndex index = this.openGlobalIndex(TemporarySapTestInfoIndex.class);
        String fallbackTestName = "Manual SAP Test by " + parameters.getSapUser() + " (started: " + DateTimeUtils.getUiFormattedDateString((long)System.currentTimeMillis()) + ")";
        ManualSapTestInfo testInfo = parameters.toManualSapTestInfo(this.serviceInfo.getInternalId(), fallbackTestName);
        if (!index.getUnfinishedTestsStartingWith(TemporarySapTestInfoIndex.makeKeyPrefix((ManualSapTestInfo)testInfo)).isEmpty()) {
            throw new BadRequestException(TEST_ALREADY_RUNNING_ERROR_MESSAGE + testInfo.getExecutingUser());
        }
        index.setTestInfo(testInfo);
        SapTestwiseCoverageCommunicator sapTiaCommunicator = this.getSapTiaCommunicator(parameters.getSapUser());
        return String.join((CharSequence)"\r\n", PREFIX_FORWARDED_ANSWER_OF_SAP_SERVER, sapTiaCommunicator.startCoverageRecordingForUser(), SapTestEventListenerService.buildNamespaceInfo(sapTiaCommunicator), testInfo.toString());
    }

    @POST
    @Path(value="update")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Update the information for a running manual SAP test", description="Updates the information (result, test description, test output message) for a running manual SAP test.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="409", description="Can not update the SAP manual test info.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    public String updateTest(@BeanParam SapTestEventListenerServiceQueryOptions parameters) throws StorageException {
        TemporarySapTestInfoIndex index = this.openGlobalIndex(TemporarySapTestInfoIndex.class);
        ManualSapTestInfo testInfo = index.update(parameters.toManualSapTestInfo(this.serviceInfo.getInternalId()), false, false);
        return "Information of SAP Test were updated: " + String.valueOf(testInfo);
    }

    @POST
    @Path(value="pause")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Pause a manual SAP test", description="Pauses a manual SAP test and updates the information (result, test description, test output message) for it.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="409", description="Can not pause the SAP manual test info.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    public String pauseTest(@BeanParam SapTestEventListenerServiceQueryOptions parameters) throws StorageException {
        TemporarySapTestInfoIndex index = this.openGlobalIndex(TemporarySapTestInfoIndex.class);
        ManualSapTestInfo testInfo = index.update(parameters.toManualSapTestInfo(this.serviceInfo.getInternalId()), true, false);
        return "Timer of SAP Test was paused (coverage collection is still running): " + String.valueOf(testInfo);
    }

    @POST
    @Path(value="stop")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Stop SAP coverage recording", description="Stops the user specific coverage recording on a SAP system for the given SAP user.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="409", description="Can not stop coverage recording for the given SAP user.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    public String stopTest(@BeanParam SapTestEventListenerServiceQueryOptions parameters) throws BadRequestException, ConQATException {
        TemporarySapTestInfoIndex index = this.openGlobalIndex(TemporarySapTestInfoIndex.class);
        ManualSapTestInfo testInfo = index.update(parameters.toManualSapTestInfo(this.serviceInfo.getInternalId()), true, true);
        SapTestwiseCoverageCommunicator sapTiaCommunicator = this.getSapTiaCommunicator(parameters.getSapUser());
        String returnMessage = sapTiaCommunicator.stopCoverageRecordingForUser(testInfo, false);
        if (returnMessage.startsWith(PREFIX_OF_SAP_SERVER_IN_CASE_OF_ERROR)) {
            throw new BadRequestException("Stopping the SAP coverage recording failed. SAP server returned: " + returnMessage);
        }
        String schedulingReason = "Scheduled coverage pickup from SAP system. '" + testInfo.makeKey() + "'.";
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), JobDescriptor.forProject((InternalProjectId)this.serviceInfo.getInternalId()).withPrivilegedTrigger(LoadAndIntegrateSapTestwiseCoverageTrigger.class).withSchedulingReason(schedulingReason).build());
        return PREFIX_FORWARDED_ANSWER_OF_SAP_SERVER + returnMessage + "\r\nTest identifier: " + testInfo.makeKey() + " get log via api/projects/{project}/sap-test-event/log/{sap-test-key}.\r\n" + String.valueOf(testInfo);
    }

    @POST
    @Path(value="reset/{sapUser}")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Reset SAP coverage recording state for a user", description="Resets Teamscale's state of the user specific coverage recording on a SAP system for the given SAP user.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="409", description="Can not reset coverage recording for the given SAP user.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    public String resetRecordingState(@Parameter(description="SAP user name for that the manual testing state should be reset.", required=true) @PathParam(value="sapUser") String sapUser) throws BadRequestException, ConQATException {
        TemporarySapTestInfoIndex index = this.openGlobalIndex(TemporarySapTestInfoIndex.class);
        ManualSapTestInfo fakeTestInfo = new ManualSapTestInfo(0, sapUser, this.serviceInfo.getInternalId(), null, null, null);
        String keyPrefix = TemporarySapTestInfoIndex.makeKeyPrefix((ManualSapTestInfo)fakeTestInfo);
        PairList entries = index.getTestInfosWithKeyPrefix(keyPrefix);
        index.removeValues(entries.extractFirstList());
        this.getSapTiaCommunicator(fakeTestInfo.getExecutingUser()).stopCoverageRecordingForUser(fakeTestInfo, true);
        return "Removed " + entries.size() + " running SAP test executions for SAP-user '" + fakeTestInfo.getExecutingUser() + "' and triggered stop of coverage recording (if running) on SAP server.";
    }

    @GET
    @Path(value="log/{sapTestKey}")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Return the log from the SAP server and general status information for a recorded (finished) test", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="409", description="Can not get status and log info for recorded SAP test.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    public String getLogInformation(@Parameter(description="Key for which recorded SAP test logging information should be retrieved.", required=true) @PathParam(value="sapTestKey") String sapTestKey) throws StorageException {
        TemporarySapTestInfoIndex index = this.openGlobalIndex(TemporarySapTestInfoIndex.class);
        ManualSapTestInfo testInfo = index.getTestInfo(sapTestKey);
        if (testInfo == null || StringUtils.isEmpty((String)testInfo.getLogMessages())) {
            return "No logging information, maybe report generation is still in progress on SAP system.";
        }
        return testInfo.getLogMessages();
    }

    @GET
    @Path(value="dump-logs-and-reports")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Returns the log from the SAP server and general status information for a recorded (finished) test.", tags={"Debugging"}, responses={@ApiResponse(responseCode="409", description="Can not get status and log info for recorded SAP test.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    @Produces(value={"application/zip"})
    public Response dumpLogsAndReports() throws IOException, ConQATException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)bos);
        TemporarySapTestInfoIndex index = this.openGlobalIndex(TemporarySapTestInfoIndex.class);
        for (ManualSapTestInfo testInfo : index.getAllTestInfos()) {
            String report = testInfo.getReport();
            if (!this.serviceInfo.getInternalId().equals((Object)testInfo.getProjectId()) || report == null) continue;
            if (JsonUtils.isValidJson((String)report)) {
                report = JsonUtils.prettyPrintJSON((String)report);
            }
            String fileNamePrefix = Stream.of(testInfo.getProjectId().toString(), testInfo.getExecutingUser(), DateTimeUtils.formatTimestamp((long)testInfo.getStartTimestamp(), (DateTimeFormatter)FILE_NAME_DATE_TIME_FORMATTER), testInfo.makeKey()).map(FileSystemUtils::toSafeFilename).collect(Collectors.joining(String.valueOf('/')));
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(fileNamePrefix + ".json"), (CharSequence)report);
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(fileNamePrefix + ".log"), (CharSequence)testInfo.getLogMessages());
        }
        zos.close();
        byte[] entity = bos.toByteArray();
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)"temporary-sap-test-info-index-dump.zip");
    }

    private SapTestwiseCoverageCommunicator getSapTiaCommunicator(String sapUser) throws StorageException, BadRequestException {
        return new SapTestwiseCoverageCommunicator((IProjectId)this.serviceInfo.getInternalId(), sapUser, this.getIndexLayer());
    }

    private static String buildNamespaceInfo(SapTestwiseCoverageCommunicator sapTiaCommunicator) {
        return "\r\nIncluded Namespaces: [" + String.join((CharSequence)", ", sapTiaCommunicator.getIncludedNamespaces()) + "]\r\nExcluded Namespaces: [" + String.join((CharSequence)", ", sapTiaCommunicator.getExcludedNamespaces()) + "]";
    }
}

