/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.TestLinks;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/test-executions")
public class TestExecutionService
extends ApiBase {
    @GET
    @Operation(summary="Get test execution", description="Retrieves a single test execution", tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TestExecutionWithPartition getTestExecutionWithPartition(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to retrieve test executions for") @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Partition to retrieve test executions for") @QueryParam(value="partition") String partition) throws StorageException {
        TestExecutionIndex result = this.openProjectIndex(TestExecutionIndex.class, this.determineHistoryOption(commit));
        return result.getTestExecution(partition, uniformPath);
    }

    @GET
    @Path(value="{testExecution}/implementation")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get test implementation path", description="Returns a test executions corresponding implementation path.", tags={"Tests"})
    @ApiResponse(responseCode="204", description="There is no test implementation for the given execution")
    public @Nullable String getTestExecutionImplementation(@PathParam(value="testExecution") @Parameter(description="The path of the test for which to return the test implementation path.") UniformPath testUniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TestLinksIndex testLinksIndex = this.openProjectIndex(TestLinksIndex.class, historyAccessOption);
        TestLinks testLinks = testLinksIndex.getTestLinks(testUniformPath.toString());
        return testLinks.getTestImplementation();
    }

    @GET
    @Path(value="{testExecution}/partitions")
    @Operation(summary="Get test execution partitions", description="Returns all partitions in which the test execution path exists.", tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Set<String> getTestExecutionPartitions(@PathParam(value="testExecution") @Parameter(description="The path of the test for which to return the partitions.") UniformPath testUniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TestLinksIndex testLinksIndex = this.openProjectIndex(TestLinksIndex.class, historyAccessOption);
        TestLinks testLinks = testLinksIndex.getTestLinks(testUniformPath.toString());
        return testLinks.getPartitions();
    }

    @GET
    @Path(value="{testExecution}/partitions/{partition}/execution-unit")
    @Operation(summary="Get the execution unit", description="Returns the path of the execution unit the given test belongs to.", tags={"Tests"})
    @ApiResponse(responseCode="204", description="The given execution is not part of an execution unit")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public @Nullable String getTestExecutionExecutionUnit(@PathParam(value="testExecution") @Parameter(description="The path of the test for which to return the execution unit.") UniformPath testUniformPath, @PathParam(value="partition") String partition, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TestExecutionIndex testLinksIndex = this.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        TestExecutionWithPartition execution = testLinksIndex.getTestExecution(partition, testUniformPath);
        return execution.getTestExecution().getExecutionUnit();
    }

    @GET
    @Path(value="partitions")
    @Operation(summary="Get all test execution partitions", description="Returns all available test execution partitions of the project that have been uploaded and processed up to the given commit.", tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getAllTestExecutionPartitionsForCommit(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="require-testwise-coverage") boolean requireTestwiseCoverage) throws StorageException {
        if (requireTestwiseCoverage) {
            CoverageUnitToMethodsMapIndex coverageUnitIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, this.determineHistoryOption(commit));
            return coverageUnitIndex.getPartitions();
        }
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, this.determineHistoryOption(commit));
        return testExecutionIndex.getPartitions();
    }

    @GET
    @Path(value="partitions/all")
    @Operation(summary="Get all test execution partitions", description="Returns the all available test execution partitions of the project across all branches.", tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getAllTestExecutionPartitionsCrossBranch() throws StorageException {
        ExternalAnalysisPartitionIndex partitionIndex = this.openProjectIndex(ExternalAnalysisPartitionIndex.class, null);
        return partitionIndex.getTestResultPartitions();
    }

    @GET
    @Path(value="partitions/details")
    @Operation(summary="Get details (name, last updated) for all test execution partitions", description="Returns all available test execution partitions and their last updated timestamp; of the project that have been uploaded and processed up to the given commit.", tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<PartitionInfo> getAllTestExecutionPartitionDetails(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ExternalResultsPartitionLastUpdateIndex lastUpdateIndex = this.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, historyAccessOption);
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        return lastUpdateIndex.getPartitionToLastUpdateMap(testExecutionIndex.getPartitions()).entrySet().stream().map(entry -> new PartitionInfo((String)entry.getKey(), ((CommitDescriptor)entry.getValue()).getTimestamp())).collect(Collectors.toList());
    }

    record PartitionInfo(@JsonProperty(value="name") String name, @JsonProperty(value="lastUpdated") long lastUpdated) {
    }
}

