/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.usage;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.MethodInfoBase;
import com.teamscale.index.testgap.abap.UsageInfo;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.usage.UsageServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.supercsv.io.CsvListWriter;

@Path(value="api/projects/{project}/code-usage/csv")
public class UsageCsvDownloadService
extends UsageServiceBase {
    private static final String CSV_HEADER_EXECUTION_COUNT = "Execution Count";
    private static final String CSV_HEADER_METHOD_NAME = "Method Name";
    private static final String CSV_HEADER_METHOD_REGION = "Method Region";
    private static final String CSV_HEADER_UNIFORM_PATH = "Uniform Path";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get code usage data as csv", description="Returns code usage information in a CSV file with the format 'Uniform Path;Method Name;Method Region;Execution Count'.", tags={"Code Usage"})
    @Produces(value={"text/csv"})
    public Response getUsageDataAsCsv(@BeanParam TimeIntervalBasedServiceQueryOptions queryOptions, @Parameter(required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath pathPrefix) throws StorageException {
        UsageCsvDownloadService usageCsvDownloadService = this;
        CommitDescriptor baselineCommit = queryOptions.resolveBaselineCommit(() -> usageCsvDownloadService.getProjectStorageSystem());
        UsageCsvDownloadService usageCsvDownloadService2 = this;
        CommitDescriptor endCommit = queryOptions.resolveEndCommit(() -> usageCsvDownloadService2.getProjectStorageSystem());
        List<UsageInfo> usageInfos = this.createRelevantUsageInfos(pathPrefix, baselineCommit, endCommit);
        return CsvServiceUtils.createCsvResponse((String)"code-usage", csvListWriter -> UsageCsvDownloadService.createUsageCsvWriter(usageInfos, csvListWriter));
    }

    private static void createUsageCsvWriter(List<UsageInfo> usageInfos, CsvListWriter csvListWriter) throws IOException {
        csvListWriter.writeHeader(new String[]{CSV_HEADER_UNIFORM_PATH, CSV_HEADER_METHOD_NAME, CSV_HEADER_METHOD_REGION, CSV_HEADER_EXECUTION_COUNT});
        usageInfos.sort(Comparator.comparing(MethodInfoBase::getUniformPath).thenComparing(info -> info.getMethodInfo().getMethodName()));
        for (UsageInfo entry : usageInfos) {
            csvListWriter.write(new Object[]{entry.getUniformPath(), entry.getMethodInfo().getMethodName(), entry.getAssociatedRegion().toString(), entry.getExecutionCount()});
        }
    }
}

