/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.UserSatisfactionFeedbackIndex;
import com.teamscale.core.user.UserSatisfactionStatusIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.CloudApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.time.LocalDate;
import java.util.ArrayList;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/user-satisfaction")
public class UserSatisfactionService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Path(value="debug-dump")
    @Operation(summary="Debug dump of user satisfaction", tags={"Users", "Debugging"}, description="Returns a textual debug dump of the user satisfaction records.")
    @Produces(value={"text/plain"})
    public String debugDumpUserSatisfaction() throws StorageException {
        StringBuilder result = new StringBuilder();
        UserSatisfactionFeedbackIndex userSatisfactionFeedbackIndex = this.openGlobalIndex(UserSatisfactionFeedbackIndex.class);
        UserSatisfactionStatusIndex userSatisfactionStatusIndex = this.openGlobalIndex(UserSatisfactionStatusIndex.class);
        PairList userSatisfactionRecords = userSatisfactionFeedbackIndex.getAllUserSatisfactionEntries();
        for (int i = 0; i < userSatisfactionRecords.size(); ++i) {
            result.append((String)userSatisfactionRecords.getFirst(i) + ": " + String.valueOf(userSatisfactionStatusIndex.getUserSatisfactionStatus(this.getUser().getUsername())) + ", Feedback entries: " + String.valueOf(userSatisfactionRecords.getSecond(i)) + "\n");
        }
        return result.toString();
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Path(value="csv-export")
    @Operation(summary="Exports user satisfaction CSV", tags={"Users"}, description="Exports a CSV of the user satisfaction feedback data.")
    @Produces(value={"text/plain"})
    @CloudApi
    public String exportUserSatisfactionCsv() throws StorageException {
        StringBuilder result = new StringBuilder();
        UserSatisfactionFeedbackIndex userSatisfactionFeedbackIndex = this.openGlobalIndex(UserSatisfactionFeedbackIndex.class);
        PairList userSatisfactionEntries = userSatisfactionFeedbackIndex.getAllUserSatisfactionEntries();
        result.append("Date;User;Rating;Feedback;MayBeContacted\n");
        for (int i = 0; i < userSatisfactionEntries.size(); ++i) {
            String username = (String)userSatisfactionEntries.getFirst(i);
            for (UserSatisfactionFeedbackIndex.UserSatisfactionFeedback feedbackEntry : (ArrayList)userSatisfactionEntries.getSecond(i)) {
                result.append(String.valueOf(feedbackEntry.date()) + ";" + username + ";" + feedbackEntry.rating() + ";" + feedbackEntry.feedback() + ";" + feedbackEntry.mayBeContacted() + "\n");
            }
        }
        return result.toString();
    }

    @POST
    @Path(value="submit")
    @RequiresNoPermission
    @Operation(summary="Submit user satisfaction", tags={"Users"}, description="Allows to submit a user satisfaction record.")
    public void submitUserSatisfactionFeedback(@RequestBody(required=true) UserSatisfactionFeedbackIndex.UserSatisfactionFeedback userSatisfactionFeedback) throws StorageException {
        this.openGlobalIndex(UserSatisfactionFeedbackIndex.class).addUserSatisfactionFeedback(this.getUser().getUsername(), userSatisfactionFeedback.withDate(LocalDate.now()));
        this.openGlobalIndex(UserSatisfactionStatusIndex.class).setUserSatisfactionStatus(this.getUser().getUsername(), UserSatisfactionStatusIndex.EUserSatisfactionStatus.SUBMITTED, LocalDate.now());
    }

    @PUT
    @Path(value="ask-later")
    @RequiresNoPermission
    @Operation(summary="Request to be asked later", tags={"Users"}, description="Allows to submit a user's request to be asked later for a user satisfaction record.")
    public void requestAskLaterForUserSatisfactionFeedback() throws StorageException {
        this.openGlobalIndex(UserSatisfactionStatusIndex.class).setUserSatisfactionStatus(this.getUser().getUsername(), UserSatisfactionStatusIndex.EUserSatisfactionStatus.ASK_LATER, LocalDate.now());
    }

    @PUT
    @Path(value="dismiss")
    @RequiresNoPermission
    @Operation(summary="Dismisses user satisfaction prompting", tags={"Users"}, description="Allows to submit a user's request to dismiss any further user satisfaction prompts.")
    public void dismissUserSatisfactionFeedbackPrompting() throws StorageException {
        this.openGlobalIndex(UserSatisfactionStatusIndex.class).setUserSatisfactionStatus(this.getUser().getUsername(), UserSatisfactionStatusIndex.EUserSatisfactionStatus.DISMISSED, LocalDate.now());
    }
}

