/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.index.merge_request.EMergeRequestUpdateTriggerSchedulingReason;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.base.RepositoryToTriggerMappingIndex;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.service.base.ApiBase;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class GitManagementPlatformWebhookServiceBase
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<? extends RepositoryChangeRetrieverBase> changeRetrieverClass;

    protected GitManagementPlatformWebhookServiceBase(Class<? extends RepositoryChangeRetrieverBase> changeRetrieverClass) {
        this.changeRetrieverClass = changeRetrieverClass;
    }

    protected void scheduleMergeRequestUpdateTriggers(String repositoryHttpUrl, String repositoryName, long mergeRequestId, Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>> triggerClass, @Nullable String webhookActor) throws StorageException {
        this.scheduleMergeRequestUpdateTriggers(repositoryHttpUrl, repositoryName, mergeRequestId, null, triggerClass, webhookActor);
    }

    protected void scheduleMergeRequestUpdateTriggers(String repositoryName, long mergeRequestId, Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>> triggerClass, @Nullable String webhookActor) throws StorageException {
        this.scheduleMergeRequestUpdateTriggers(repositoryName, repositoryName, mergeRequestId, null, triggerClass, webhookActor);
    }

    protected void scheduleMergeRequestUpdateTriggers(String repositoryHttpUrl, String repositoryName, long mergeRequestId, @Nullable String extraJobParameter, Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>> triggerClass, @Nullable String webhookActor) throws StorageException {
        boolean run = this.runForEachProjectWithRepository(repositoryHttpUrl, (projectInfo, projectStorageSystem) -> this.initAndScheduleJobForMergeRequest(new MergeRequestIdentifier(repositoryName, mergeRequestId), extraJobParameter, (ProjectInfo)projectInfo, triggerClass), webhookActor);
        if (!run) {
            LOGGER.debug("Did not schedule any MergeRequestUpdateTrigger for webhook event with repositoryHttpUrl \"{}\" and mergeRequestId \"{}\"", (Object)repositoryHttpUrl, (Object)mergeRequestId);
        }
    }

    protected void scheduleMergeRequestUpdateTriggers(String repositoryHttpUrl, String repositoryName, String sourceCommitHash, @Nullable String extraJobParameter, Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>> triggerClass) throws StorageException {
        AtomicBoolean mergeRequestFound = new AtomicBoolean(false);
        boolean run = this.runForEachProjectWithRepository(repositoryHttpUrl, (projectInfo, projectStorageSystem) -> {
            try {
                MergeRequestIndex mergeRequestIndex = (MergeRequestIndex)projectStorageSystem.openProjectIndex(MergeRequestIndex.class, null);
                Optional mr = mergeRequestIndex.getMergeRequest(sourceCommitHash);
                if (mr.isEmpty()) {
                    LOGGER.debug("Could not find a merge request with source commit hash {} in repository {} in project {}", (Object)sourceCommitHash, (Object)repositoryName, (Object)projectInfo.getPrimaryPublicId());
                    return;
                }
                mergeRequestFound.set(true);
                this.initAndScheduleJobForMergeRequest(((MergeRequest)mr.get()).identifier, extraJobParameter, (ProjectInfo)projectInfo, triggerClass);
            }
            catch (StorageException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to look for merge request with commit {} in repository {} in project {}", (Object)sourceCommitHash, (Object)repositoryName, (Object)projectInfo.getPrimaryPublicId());
            }
        }, null);
        if (!run) {
            LOGGER.debug("Did not schedule any MergeRequestUpdateTrigger for webhook event with repositoryHttpUrl \"{}\" and commit hash \"{}\" because no Teamscale project could be found for the repository", (Object)repositoryHttpUrl, (Object)sourceCommitHash);
        } else if (!mergeRequestFound.get()) {
            LOGGER.debug("Did not schedule any MergeRequestUpdateTrigger for webhook event with repositoryHttpUrl \"{}\" and commit hash \"{}\" because no merge request with this commit as HEAD could be found. This is expected when the commit is not the HEAD commit of a merge request or the commit or merge request is not yet analyzed.", (Object)repositoryHttpUrl, (Object)sourceCommitHash);
        }
    }

    private void initAndScheduleJobForMergeRequest(MergeRequestIdentifier mergeRequestIdentifier, @Nullable String extraJobParameter, ProjectInfo projectInfo, Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>> triggerClass) {
        MergeRequestUpdateTriggerBase.JobParameter parameter = new MergeRequestUpdateTriggerBase.JobParameter(mergeRequestIdentifier, false, extraJobParameter);
        JobDescriptor job = JobDescriptor.forProject((InternalProjectId)projectInfo.getInternalId()).withPrivilegedTrigger(triggerClass).withSchedulingReason(EMergeRequestUpdateTriggerSchedulingReason.WEBHOOK_RECEIVED.format(mergeRequestIdentifier.id())).withParameter((Object)parameter).build();
        try {
            ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), job);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to run update job for merge request {} in repository {}", (Object)mergeRequestIdentifier.id(), (Object)mergeRequestIdentifier.repositoryPath(), (Object)e);
        }
    }

    protected void updateCrossRepositorySourceBranchIndex(String repositoryName, CrossRepositoryMergeRequestSourceBranch sourceBranch) {
        try {
            this.runForEachProjectWithRepository(repositoryName, (projectInfo, projectStorageSystem) -> {
                try {
                    Optional connector = MergeRequestUtils.guessConnectorFromProject((IndexLayer)this.getIndexLayer(), (IProjectId)projectInfo.getInternalId(), (String)repositoryName);
                    if (connector.isEmpty()) {
                        LOGGER.debug("Could not find matching connector for repository '{}' in project '{}'. Skipping cross-repository source branch index update.", (Object)repositoryName, (Object)projectInfo.getPrimaryPublicId());
                        return;
                    }
                    String indexName = CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName((String)((ConnectorConfiguration)connector.get()).getIdentifier());
                    CrossRepositoryMergeRequestSourceBranchesIndex index = (CrossRepositoryMergeRequestSourceBranchesIndex)this.getIndexLayer().openProjectIndex((IProjectId)projectInfo.getInternalId(), CrossRepositoryMergeRequestSourceBranchesIndex.class, indexName, null);
                    index.computeWithLock(access -> access.updateBranch(sourceBranch));
                    LOGGER.debug("Updated cross-repository source branch index for MR {} in repository '{}' in project '{}'.", (Object)sourceBranch.mergeRequestId(), (Object)repositoryName, (Object)projectInfo.getPrimaryPublicId());
                }
                catch (StorageException e) {
                    LOGGER.atError().withThrowable((Throwable)e).log("Failed to update cross-repository source branch index for MR {} in repository '{}' in project '{}'.", (Object)sourceBranch.mergeRequestId(), (Object)repositoryName, (Object)projectInfo.getPrimaryPublicId());
                }
            }, null);
        }
        catch (StorageException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to update cross-repository source branch index for MR {} in repository '{}'. The MergeRequestUpdateTrigger will update it later.", (Object)sourceBranch.mergeRequestId(), (Object)repositoryName);
        }
    }

    protected void deleteMergeRequestsFromIndex(MergeRequestIdentifier identifier) throws StorageException {
        boolean run = this.runForEachProjectWithRepository(identifier.repositoryPath(), (projectInfo, projectStorageSystem) -> {
            try {
                MergeRequestIndex mergeRequestIndex = (MergeRequestIndex)projectStorageSystem.openProjectIndex(MergeRequestIndex.class, null);
                mergeRequestIndex.removeMergeRequest(identifier);
            }
            catch (StorageException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to delete merge request {} from {}", (Object)identifier.id(), (Object)identifier.repositoryPath());
            }
        }, null);
        if (!run) {
            LOGGER.debug("Did not delete any MergeRequest with MergeRequestIdentifier \"{}\"", (Object)identifier);
        }
    }

    protected boolean runForEachProjectWithRepository(String repositoryHttpUrl, BiConsumer<ProjectInfo, ProjectStorageSystem> projectAndProjectStorageSystemConsumer, @Nullable String webhookActor) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        boolean foundForAnyProject = false;
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            CommitResolvingStorageSystem projectStorageSystem;
            if (projectInfo.isDeletingOrReanalyzing() || this.hookWasCalledByTeamscale(projectInfo, webhookActor) || !this.hasGitManagementPlatformChangeRetriever(projectInfo, (ProjectStorageSystem)(projectStorageSystem = this.getProjectStorageSystem(projectInfo)), repositoryHttpUrl)) continue;
            foundForAnyProject = true;
            projectAndProjectStorageSystemConsumer.accept(projectInfo, (ProjectStorageSystem)projectStorageSystem);
        }
        return foundForAnyProject;
    }

    private boolean hookWasCalledByTeamscale(ProjectInfo projectInfo, @Nullable String webhookActor) throws StorageException {
        ERepositoryConnector repositoryConnectorType = this.getRepositoryConnectorType();
        if (repositoryConnectorType != null && webhookActor != null) {
            List relevantVotingConnectors = ConnectorUtils.getRepositoryConnectors((MetaIndex)((MetaIndex)this.getProjectStorageSystem(projectInfo).openProjectIndex(MetaIndex.class, null)), (ERepositoryConnector)repositoryConnectorType);
            for (ConnectorConfiguration connector : relevantVotingConnectors) {
                if (!this.isConfiguredWithHookCallingUser(connector, webhookActor)) continue;
                return true;
            }
        }
        return false;
    }

    protected ERepositoryConnector getRepositoryConnectorType() {
        return null;
    }

    private boolean isConfiguredWithHookCallingUser(ConnectorConfiguration loadedConnector, @NonNull String webhookActor) throws StorageException {
        if (!Boolean.parseBoolean(loadedConnector.getOptionValue("Ignore webhooks from configured user"))) {
            return false;
        }
        ExternalCredentials credentials = this.getExternalCredentialsForConnector(loadedConnector);
        if (StringUtils.isEmpty((String)credentials.username)) {
            return false;
        }
        return credentials.username.equals(webhookActor);
    }

    private boolean hasGitManagementPlatformChangeRetriever(ProjectInfo projectInfo, ProjectStorageSystem projectStorageSystem, String repositoryHttpUrl) throws StorageException {
        RepositoryToTriggerMappingIndex mappingIndex = (RepositoryToTriggerMappingIndex)projectStorageSystem.openProjectIndex(RepositoryToTriggerMappingIndex.class, null);
        TriggerIndex triggerIndex = (TriggerIndex)projectStorageSystem.openProjectIndex(TriggerIndex.class, null);
        List triggerNamesForURL = mappingIndex.getTriggerNamesForURL(repositoryHttpUrl);
        List triggerDescriptions = triggerIndex.getTriggers(triggerNamesForURL);
        LOGGER.debug("Reading stored descriptions for trigger names \"{}\" in mapped to URL \"{}\" in project \"{}\": {}", (Object)triggerNamesForURL, (Object)repositoryHttpUrl, (Object)projectInfo.getPrimaryPublicId(), (Object)triggerDescriptions);
        return triggerDescriptions.stream().map(TriggerDescription::getTriggerClass).anyMatch(this.changeRetrieverClass::equals);
    }

    private ExternalCredentials getExternalCredentialsForConnector(ConnectorConfiguration loadedConnector) throws StorageException {
        String accountIdentifier = loadedConnector.getOptionValue("Account");
        if (accountIdentifier == null) {
            throw new StorageException("Could not find external credentials for connector with id: " + loadedConnector.getIdentifier() + ". This should never happen.");
        }
        ExternalCredentials externalCredentials = this.openGlobalIndex(ExternalCredentialsIndex.class).getExternalCredentials(accountIdentifier);
        if (externalCredentials == null) {
            throw new StorageException("Could not find external credentials with account identifier " + accountIdentifier + ". This should never happen.");
        }
        return externalCredentials;
    }
}

