/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github.event_handler;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import com.teamscale.service.webhook.github.data.CommitStatusPayload;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerBase;
import com.teamscale.service.webhook.github.event_handler.IMergeRequestUpdateTriggerSchedulingHelper;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.intellij.lang.annotations.Language;

class GitHubCommitStatusEventHandler
extends GitHubWebhookEventHandlerBase {
    private final IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper;

    GitHubCommitStatusEventHandler(IndexLayer indexLayer, IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper) {
        super(indexLayer);
        this.schedulingHelper = schedulingHelper;
    }

    @Override
    public void handle(@Language(value="JSON") String eventPayload) throws StorageException, JsonSerializationException {
        CommitStatusPayload commitStatusPayload = (CommitStatusPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)eventPayload, CommitStatusPayload.class);
        String cloneUrl = commitStatusPayload.repository().cloneUrl();
        String repositoryName = commitStatusPayload.repository().fullName();
        GitHubCommitStatus commitStatus = new GitHubCommitStatus(commitStatusPayload.context(), commitStatusPayload.state());
        this.schedulingHelper.addCommitStatusToWebhookPayLoadIndex(cloneUrl, repositoryName, commitStatusPayload.sha(), commitStatus);
        this.schedulingHelper.scheduleMergeRequestUpdateTriggersForCommit(cloneUrl, repositoryName, commitStatusPayload.sha());
    }
}

