/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.util;

import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import com.teamscale.service.framework.versioning.LegacyApi;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class LegacyApiUtils {
    public static final String SUCCESS_STRING = "success";
    public static final String FAILURE_STRING = "failure";

    public static Response plainTextSuccess() {
        return LegacyApiUtils.plainText(SUCCESS_STRING);
    }

    public static Response plainText(String text) {
        return Response.ok((Object)text, (String)"text/plain").build();
    }

    public static boolean isLegacyApi(Method method) {
        return ServiceAnnotationUtils.getMethodOrClassAnnotation(LegacyApi.class, method) != null;
    }

    @SafeVarargs
    public static <T, E extends Throwable> Response apiCallWithSuccess(Class<T> resourceClass, ResourceContext resourceContext, ApiVoidCall<T, E> apiVoidCall, ExceptionWrapper<?, E> ... exceptionWrappers) throws E {
        LegacyApiUtils.apiCallWithResult(resourceClass, resourceContext, apiVoidCall.toApiCall(), exceptionWrappers);
        return LegacyApiUtils.plainTextSuccess();
    }

    @SafeVarargs
    public static <T, R, E extends Throwable> R apiCallWithResult(Class<T> resourceClass, ResourceContext resourceContext, ApiCall<T, R, E> apiCall, ExceptionWrapper<?, E> ... exceptionWrappers) throws E {
        Object resource = resourceContext.getResource(resourceClass);
        try {
            return apiCall.call(resource);
        }
        catch (Throwable e) {
            for (ExceptionWrapper<?, E> exceptionWrapper : exceptionWrappers) {
                if (!exceptionWrapper.canHandle(e)) continue;
                exceptionWrapper.wrapAndRethrow(e);
            }
            throw e;
        }
    }

    public static <E extends Throwable> ExceptionWrapper<NotFoundException, E> wrapNotFoundInBadRequest() {
        return ExceptionWrapper.wrapRuntimeException(NotFoundException.class, BadRequestException::new);
    }

    private LegacyApiUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static interface ApiVoidCall<T, E extends Throwable> {
        public void call(T var1) throws E;

        default public ApiCall<T, Void, E> toApiCall() {
            return resource -> {
                this.call(resource);
                return null;
            };
        }
    }

    public static interface ApiCall<T, R, E extends Throwable> {
        public R call(T var1) throws E;
    }

    public static class ExceptionWrapper<Caught extends Throwable, Thrown extends Throwable> {
        private final Class<Caught> caughtThrowableClass;
        private BiFunction<String, Caught, RuntimeException> runtimeExceptionWrapper;

        private ExceptionWrapper(Class<Caught> caughtThrowableClass) {
            this.caughtThrowableClass = caughtThrowableClass;
        }

        public static <Caught extends Throwable, Thrown extends Throwable> ExceptionWrapper<Caught, Thrown> wrapRuntimeException(Class<Caught> caughtClass, BiFunction<String, Caught, RuntimeException> wrapper) {
            ExceptionWrapper<Caught, Thrown> exceptionWrapper = new ExceptionWrapper<Caught, Thrown>(caughtClass);
            exceptionWrapper.runtimeExceptionWrapper = wrapper;
            return exceptionWrapper;
        }

        private boolean canHandle(Throwable e) {
            return this.caughtThrowableClass.isInstance(e);
        }

        private void wrapAndRethrow(Throwable e) {
            Throwable caught = (Throwable)this.caughtThrowableClass.cast(e);
            throw this.runtimeExceptionWrapper.apply(caught.getMessage(), caught);
        }
    }
}

