/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.waiting.ICombinedCondition;
import org.conqat.lib.commons.waiting.IConditionResult;
import org.conqat.lib.commons.waiting.IWaitCondition;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ThreadSafe
public final class AndCondition
implements ICombinedCondition {
    private final List<IWaitCondition> conditions;

    public AndCondition(Collection<? extends IWaitCondition> conditions) {
        this.conditions = List.copyOf(conditions);
    }

    @Override
    public IConditionResult check() throws Exception {
        IConditionResult result = IConditionResult.fulfilled();
        for (IWaitCondition condition : this.conditions) {
            result = condition.check();
            if (result.isTerminated()) {
                return result;
            }
            if (!result.isPending()) continue;
            return result;
        }
        return result;
    }

    @Override
    public UnmodifiableList<? extends IWaitCondition> getConditions() {
        return CollectionUtils.asUnmodifiable(this.conditions);
    }
}

