/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.util.function.Supplier;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public sealed interface IConditionResult {
    default public boolean isFulfilled() {
        return false;
    }

    default public boolean isPending() {
        return false;
    }

    default public boolean isTerminated() {
        return false;
    }

    public String getDescription();

    default public @Nullable String getFailureReason() {
        return null;
    }

    default public <T> @Nullable T getValue() {
        return null;
    }

    default public String getPendingInfo() {
        return Formatter.combineDescriptionAndFailureReason(this.getDescription(), this.getFailureReason());
    }

    default public String formatFailureMessage(@Nullable String waitSpecDescription) {
        return Formatter.formatDescription(waitSpecDescription, this.getDescription()) + this.getFailureReason();
    }

    public static IConditionResult fulfilled() {
        return new Fulfilled<Object>(null, null);
    }

    public static IConditionResult fulfilled(@Nullable String description) {
        return IConditionResult.fulfilledWithValue(null, description);
    }

    public static <T> IConditionResult fulfilledWithValue(@Nullable T value, @Nullable String description) {
        return new Fulfilled<T>(value, description);
    }

    public static IConditionResult pending(String pendingReason) {
        return IConditionResult.pending(pendingReason, null);
    }

    public static IConditionResult pending(String pendingReason, @Nullable String description) {
        return new Pending(pendingReason, description);
    }

    public static IConditionResult terminated(String terminationReason) {
        return IConditionResult.terminated(terminationReason, null);
    }

    public static IConditionResult terminated(String terminationReason, @Nullable String description) {
        return new Terminated(terminationReason, description);
    }

    public static IConditionResult of(boolean condition, Supplier<String> pendingReasonSupplier) {
        return IConditionResult.of(condition, null, pendingReasonSupplier);
    }

    public static IConditionResult of(boolean condition, @Nullable String description, Supplier<String> pendingReasonSupplier) {
        if (condition) {
            return IConditionResult.fulfilled(description);
        }
        return IConditionResult.pending(pendingReasonSupplier.get(), description);
    }

    public static final class Formatter {
        private Formatter() {
            throw new UtilsInstantiationNotSupportedException();
        }

        static String formatDescription(@Nullable String waitSpecDescription, @Nullable String resultDescription) {
            String description = Formatter.chooseDescription(waitSpecDescription, resultDescription);
            if (description.isEmpty()) {
                return "";
            }
            return "Waiting for " + description + ".\n";
        }

        static String chooseDescription(@Nullable String waitSpecDescription, @Nullable String resultDescription) {
            waitSpecDescription = StringUtils.emptyIfNull(waitSpecDescription).strip();
            resultDescription = StringUtils.emptyIfNull(resultDescription).strip();
            if (waitSpecDescription.isEmpty()) {
                return resultDescription;
            }
            if (resultDescription.isEmpty()) {
                return waitSpecDescription;
            }
            if (waitSpecDescription.equals(resultDescription)) {
                return waitSpecDescription;
            }
            return resultDescription + " (" + waitSpecDescription + ")";
        }

        static String combineDescriptionAndFailureReason(String description, String failureReason) {
            if (StringUtils.isEmpty(description)) {
                return failureReason;
            }
            if (StringUtils.isEmpty(failureReason)) {
                return description;
            }
            return description + ": " + failureReason;
        }
    }

    public record Fulfilled<T>(@Nullable T value, @Nullable String description) implements IConditionResult
    {
        @Override
        public boolean isFulfilled() {
            return true;
        }

        @Override
        public String getDescription() {
            return StringUtils.emptyIfNull(this.description);
        }

        @Override
        public @Nullable T getValue() {
            return this.value;
        }
    }

    public record Pending(String pendingReason, @Nullable String description) implements INotFulfilled
    {
        @Override
        public boolean isPending() {
            return true;
        }

        @Override
        public String getDescription() {
            return StringUtils.emptyIfNull(this.description);
        }

        @Override
        public String getFailureReason() {
            return StringUtils.emptyIfNull(this.pendingReason);
        }
    }

    public record Terminated(String terminationReason, @Nullable String description) implements INotFulfilled
    {
        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public String getDescription() {
            return StringUtils.emptyIfNull(this.description);
        }

        @Override
        public String getFailureReason() {
            return StringUtils.emptyIfNull(this.terminationReason);
        }
    }

    public static sealed interface INotFulfilled
    extends IConditionResult
    permits Pending, Terminated {
        @Override
        public String getFailureReason();
    }
}

