/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.RequireThreadSafe;
import org.conqat.lib.commons.waiting.AndCondition;
import org.conqat.lib.commons.waiting.IConditionResult;
import org.conqat.lib.commons.waiting.OrCondition;
import org.conqat.lib.commons.waiting.TerminationCondition;
import org.conqat.lib.commons.waiting.WaitCondition;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@FunctionalInterface
@RequireThreadSafe
public interface IWaitCondition {
    public IConditionResult check() throws Exception;

    default public IWaitCondition and(IWaitCondition other) {
        return IWaitCondition.allOf(List.of(this, other));
    }

    default public IWaitCondition or(IWaitCondition other) {
        return IWaitCondition.anyOf(List.of(this, other));
    }

    default public IWaitCondition asTerminationCondition() {
        return new TerminationCondition(this);
    }

    public static IWaitCondition of(SupplierWithException<Boolean, Exception> check) {
        return IWaitCondition.of(check, "condition to be true");
    }

    public static IWaitCondition of(SupplierWithException<Boolean, Exception> check, String description) {
        return IWaitCondition.of(check, () -> description);
    }

    public static IWaitCondition of(SupplierWithException<Boolean, Exception> check, SupplierWithException<String, Exception> descriptionSupplier) {
        return new WaitCondition(check, descriptionSupplier);
    }

    public static IWaitCondition condition(SupplierWithException<IConditionResult, Exception> supplier) {
        return supplier::get;
    }

    public static IWaitCondition allOf(IWaitCondition ... conditions) {
        return IWaitCondition.allOf(Arrays.asList(conditions));
    }

    public static IWaitCondition allOf(Collection<? extends IWaitCondition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("At least one condition required for allOf");
        }
        if (conditions.size() == 1) {
            return conditions.iterator().next();
        }
        return new AndCondition(conditions);
    }

    public static IWaitCondition anyOf(IWaitCondition ... conditions) {
        return IWaitCondition.anyOf(Arrays.asList(conditions));
    }

    public static IWaitCondition anyOf(Collection<IWaitCondition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("At least one condition required for anyOf");
        }
        if (conditions.size() == 1) {
            return conditions.iterator().next();
        }
        return new OrCondition(conditions);
    }

    public static IWaitCondition nonEmptyMessage(SupplierWithException<@Nullable String, Exception> messageSupplier) {
        SupplierWithException resultSupplier = () -> {
            String message = (String)messageSupplier.get();
            if (!StringUtils.isEmpty(message)) {
                return IConditionResult.fulfilledWithValue(message, message);
            }
            return IConditionResult.pending("message supplier returned null or empty");
        };
        return resultSupplier::get;
    }

    public static <T> IWaitCondition nonEmptyCollection(SupplierWithException<@Nullable Collection<T>, Exception> collectionSupplier) {
        SupplierWithException resultSupplier = () -> {
            Collection collection = (Collection)collectionSupplier.get();
            if (!CollectionUtils.isNullOrEmpty(collection)) {
                return IConditionResult.fulfilledWithValue(collection, "found collection with %d elements".formatted(collection.size()));
            }
            return IConditionResult.pending("collection supplier returned null or empty");
        };
        return resultSupplier::get;
    }

    public static <T> IWaitCondition optional(SupplierWithException<Optional<T>, Exception> optionalSupplier, SupplierWithException<String, Exception> descriptionSupplier) {
        SupplierWithException resultSupplier = () -> {
            Optional optional = (Optional)optionalSupplier.get();
            String description = (String)descriptionSupplier.get();
            return optional.map(value -> IConditionResult.fulfilledWithValue(value, description)).orElseGet(() -> IConditionResult.pending("Optional was empty", description));
        };
        return resultSupplier::get;
    }

    public static <T> IWaitCondition optional(SupplierWithException<Optional<T>, Exception> optionalSupplier, String description) {
        return IWaitCondition.optional(optionalSupplier, () -> description);
    }

    public static <T> IWaitCondition optional(SupplierWithException<Optional<T>, Exception> optionalSupplier) {
        return IWaitCondition.optional(optionalSupplier, () -> "Optional to contain a value");
    }

    public static <T> IWaitCondition value(SupplierWithException<@Nullable T, Exception> valueSupplier, SupplierWithException<String, Exception> descriptionSupplier) {
        return IWaitCondition.optional(() -> Optional.ofNullable(valueSupplier.get()), descriptionSupplier);
    }

    public static <T> IWaitCondition value(SupplierWithException<@Nullable T, Exception> valueSupplier, String description) {
        return IWaitCondition.value(valueSupplier, () -> description);
    }

    public static <T> IWaitCondition value(SupplierWithException<@Nullable T, Exception> valueSupplier) {
        return IWaitCondition.value(valueSupplier, "value to be non-null");
    }
}

