/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.waiting.ICombinedCondition;
import org.conqat.lib.commons.waiting.IConditionResult;
import org.conqat.lib.commons.waiting.IWaitCondition;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ThreadSafe
public final class OrCondition
implements ICombinedCondition {
    private final List<IWaitCondition> conditions;

    public OrCondition(Collection<? extends IWaitCondition> conditions) {
        this.conditions = List.copyOf(conditions);
    }

    @Override
    public IConditionResult check() throws Exception {
        ArrayList<CallSite> pendingConditions = new ArrayList<CallSite>();
        for (int i = 0; i < this.conditions.size(); ++i) {
            IConditionResult result = this.conditions.get(i).check();
            if (result.isTerminated()) {
                return result;
            }
            if (result.isFulfilled()) {
                return result;
            }
            pendingConditions.add((CallSite)((Object)("(" + (i + 1) + ") " + result.getPendingInfo())));
        }
        String combinedPendingReason = "0 of " + this.conditions.size() + " conditions met yet: " + String.join((CharSequence)", ", pendingConditions);
        return IConditionResult.pending(combinedPendingReason);
    }

    @Override
    public UnmodifiableList<? extends IWaitCondition> getConditions() {
        return CollectionUtils.asUnmodifiable(this.conditions);
    }
}

