/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.commons.waiting.AbstractWaitSpec;
import org.conqat.lib.commons.waiting.IWaitCondition;
import org.conqat.lib.commons.waiting.WaitResult;
import org.conqat.lib.commons.waiting.WaitSpec;
import org.conqat.lib.commons.waiting.WaitTimeoutException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class WaitUtil {
    private WaitUtil() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static <T> WaitSpec<T, WaitTimeoutException, ?> condition(IWaitCondition condition) {
        return new WaitSpec(condition, WaitUtil::defaultExceptionFunction);
    }

    private static WaitTimeoutException defaultExceptionFunction(WaitResult<?> result) {
        return new WaitTimeoutException("Wait condition was in state " + String.valueOf((Object)result.outcome()) + " after " + String.valueOf(result.elapsed()) + ": " + result.failureReason(), result.configuredTimeout(), Objects.requireNonNull(result.failureReason()));
    }

    public static WaitSpec<Boolean, WaitTimeoutException, ?> condition(SupplierWithException<Boolean, Exception> check) {
        return WaitUtil.condition(IWaitCondition.of(check, "condition to be true"));
    }

    public static WaitSpec<String, WaitTimeoutException, ?> nonEmptyMessage(SupplierWithException<@Nullable String, Exception> messageSupplier) {
        return WaitUtil.condition(IWaitCondition.nonEmptyMessage(messageSupplier));
    }

    public static <T> WaitSpec<T, WaitTimeoutException, ?> optional(SupplierWithException<Optional<T>, Exception> optionalSupplier) {
        return WaitUtil.condition(IWaitCondition.optional(optionalSupplier));
    }

    public static <T> WaitSpec<T, WaitTimeoutException, ?> value(SupplierWithException<@Nullable T, Exception> valueSupplier) {
        return WaitUtil.condition(IWaitCondition.value(valueSupplier));
    }

    public static WaitResult<?> until(LocalDateTime targetTime) {
        return WaitUtil.until(targetTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static WaitResult<?> until(Instant targetInstant) {
        Duration timeout = Duration.between(Instant.now(), targetInstant);
        if (timeout.isNegative() || timeout.isZero()) {
            return AbstractWaitSpec.success(Instant.now(), Duration.ofMillis(0L), null);
        }
        return ((WaitSpec)((WaitSpec)((WaitSpec)WaitUtil.condition(() -> !Instant.now().isBefore(targetInstant)).asWaitingFor("time to reach " + String.valueOf(targetInstant))).timeout(timeout.multipliedBy(2L))).pollInterval(timeout)).continueSilentlyOnTimeoutOrInterrupt().execute();
    }

    public static WaitResult<?> until(ZonedDateTime targetTime) {
        return WaitUtil.until(targetTime.toLocalDateTime());
    }
}

