/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.cookie;

import com.teamscale.core.rest.client.cookie.Cookie;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CookieUtils {
    public static final String DESCRIPTOR_PARAMETER_NAME = "Cookies";
    public static final String DESCRIPTOR_PARAMETER_DESCRIPTION = "Pattern: (<domain>:)?<name>=<value>";
    public static final String COOKIES_PARAMETER = "cookies";
    private static final Pattern COOKIE_PATTERN = Pattern.compile("((.*?):)?(.*?)=(.*?)");

    public static List<Cookie> parseCookies(URI uri, List<String> cookieStringList) {
        CCSMAssert.isNotNull((Object)uri, (String)"URI is null");
        return CollectionUtils.map(cookieStringList, cookie -> CookieUtils.parseCookie(uri, cookie));
    }

    public static Cookie parseCookie(URI uri, String cookieString) {
        Matcher matcher = COOKIE_PATTERN.matcher(cookieString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Cookie string cannot be parsed: " + cookieString);
        }
        String domain = CookieUtils.determineDomain(matcher.group(2), uri);
        String name = matcher.group(3);
        String value = matcher.group(4);
        return new Cookie(name, value, domain);
    }

    private static String determineDomain(String matchedDomain, URI uri) {
        if (matchedDomain != null) {
            return StringUtils.stripPrefix((String)matchedDomain, (String)".");
        }
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        throw new IllegalArgumentException("The domain for the cookie cannot be retrieved from the URL. Therefore, the cookie domain must be specified.");
    }

    private CookieUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

