/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.jsbuild.export.ExportedTypeScriptClass;
import com.teamscale.jsbuild.export.TypeScriptImportStatement;
import com.teamscale.jsbuild.export.TypescriptType;
import com.teamscale.jsbuild.export.TypescriptTypeExporterBase;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class ExportedTypeScriptClassGenerator {
    private static final Pattern TYPE_MATCHER = Pattern.compile("(\\b(?<!')[\\w\\d_]+)");
    private static final Pattern ENUM_TYPE_MATCHER = Pattern.compile("E[A-Z].*Entry");
    private static final Set<String> BUILT_IN_TYPES = Set.of("number", "string", "boolean", "Array", "null", "undefined", "unknown", "Record", "Partial");
    private StringBuilder fileContentBuilder;
    private final ExportedTypeScriptClass classToExport;
    private int tabIndent = 0;
    private final Set<TypeScriptImportStatement> imports = new HashSet<TypeScriptImportStatement>();

    public ExportedTypeScriptClassGenerator(ExportedTypeScriptClass classToExport) {
        this.classToExport = classToExport;
    }

    public String build() throws IOException {
        this.fileContentBuilder = new StringBuilder();
        Class<?> parentClass = this.classToExport.getParentClass();
        if (parentClass != null) {
            this.imports.add(new TypeScriptImportStatement("typedefs/" + TypescriptTypeExporterBase.createDataClassTypeName(parentClass), true));
        }
        this.writeTypeDocumentation();
        this.writeTypeDefinition(this.classToExport.clazz, this.classToExport.getParentClass());
        this.writeImportStatements();
        return this.fileContentBuilder.toString();
    }

    private void writeTypeDefinition(Class<?> clazz, Class<?> parentClass) throws IOException {
        if (parentClass != null && this.classToExport.propertiesWithTypes.isEmpty()) {
            this.writeLine("export type ", TypescriptTypeExporterBase.createDataClassTypeName(clazz), " = ", TypescriptTypeExporterBase.createDataClassTypeName(parentClass), ";");
        } else if (parentClass != null) {
            this.writeLine("export type ", TypescriptTypeExporterBase.createDataClassTypeName(clazz), " = ", TypescriptTypeExporterBase.createDataClassTypeName(parentClass), " & {");
            this.indentWithTab(this::writeTopPropertiesDeclarations);
            this.writeLine("}");
        } else {
            this.writeLine("export type ", TypescriptTypeExporterBase.createDataClassTypeName(clazz), " = {");
            this.indentWithTab(this::writeTopPropertiesDeclarations);
            this.writeLine("}");
        }
    }

    private void writeImportStatements() {
        if (this.imports.size() > 0) {
            this.fileContentBuilder.insert(0, "\n");
        }
        this.imports.forEach(importedModule -> this.fileContentBuilder.insert(0, importedModule.toCode()));
    }

    private void writeTypeDocumentation() {
        this.writeLine("/**");
        this.writeLine(" * Generated from Java type ", this.classToExport.clazz.getName(), ".");
        this.writeLine(" */");
    }

    private void writeTopPropertiesDeclarations() {
        PairList propertiesWithTypes = new PairList(this.classToExport.propertiesWithTypes);
        CollectionUtils.sortByFirst((PairList)propertiesWithTypes, (Comparator)String.CASE_INSENSITIVE_ORDER);
        for (Pair propertyWithType : propertiesWithTypes) {
            String propertyName = (String)propertyWithType.getFirst();
            TypescriptType type = this.registerTypesIfNeeded((TypescriptType)propertyWithType.getSecond());
            if (type.isNullable()) {
                this.writeLine(propertyName, "?: ", type.getType(), ";");
                continue;
            }
            this.writeLine(propertyName, ": ", type.getType(), ";");
        }
    }

    private TypescriptType registerTypesIfNeeded(TypescriptType typeExpression) {
        Matcher customTypeMatcher = TYPE_MATCHER.matcher(typeExpression.getType());
        while (customTypeMatcher.find()) {
            String plainType = customTypeMatcher.group(1);
            if (BUILT_IN_TYPES.contains(plainType)) continue;
            if (plainType.equals("PairList")) {
                this.imports.add(new TypeScriptImportStatement("custom-types/PairList", true));
                continue;
            }
            if (plainType.equals("Pair")) {
                this.imports.add(new TypeScriptImportStatement("custom-types/Pair", true));
                continue;
            }
            if (plainType.equals(this.classToExport.clazz.getSimpleName()) || !ExportedTypeScriptClassGenerator.startsWithUpperCaseLetter(plainType)) continue;
            if (ENUM_TYPE_MATCHER.matcher(plainType).matches()) {
                this.imports.add(new TypeScriptImportStatement("typedefs/" + StringUtils.stripSuffix((String)plainType, (String)"Entry"), plainType, true));
                continue;
            }
            this.imports.add(new TypeScriptImportStatement("typedefs/" + plainType, true));
        }
        return typeExpression;
    }

    private static boolean startsWithUpperCaseLetter(String plainType) {
        String firstCharacter = plainType.substring(0, 1);
        return firstCharacter.equals(firstCharacter.toUpperCase());
    }

    private void indentWithTab(RunnableWithException<IOException> indentedWriteActions) throws IOException {
        ++this.tabIndent;
        indentedWriteActions.run();
        --this.tabIndent;
    }

    private void writeLine(String ... parts) {
        for (int i = 0; i < this.tabIndent; ++i) {
            this.fileContentBuilder.append("\t");
        }
        for (String part : parts) {
            this.fileContentBuilder.append(part);
        }
        this.fileContentBuilder.append("\n");
    }

    @FunctionalInterface
    public static interface RunnableWithException<T extends Throwable> {
        public void run() throws T;
    }
}

