/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class SignedFloatBinding
extends ComparableBinding {
    public static final SignedFloatBinding BINDING = new SignedFloatBinding();

    private SignedFloatBinding() {
    }

    @Override
    public Float readObject(@NotNull ByteArrayInputStream stream) {
        return Float.valueOf(BindingUtils.readSignedFloat(stream));
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        int intValue;
        output.writeUnsignedInt(intValue ^ ((intValue = Float.floatToIntBits(((Float)object).floatValue())) < 0 ? -1 : Integer.MIN_VALUE));
    }

    public static float entryToFloat(@NotNull ByteIterable entry) {
        return ((Float)BINDING.entryToObject(entry)).floatValue();
    }

    public static ArrayByteIterable floatToEntry(float object) {
        return BINDING.objectToEntry(Float.valueOf(object));
    }
}

