/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.wia;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.wia.EWorkItemType;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="workItemType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TeamscaleIssue.class, name="ISSUE_ITEM"), @JsonSubTypes.Type(value=SpecItem.class, name="SPEC_ITEM")})
@IndexValueClass(containedInBackup=true)
public class TeamscaleIssue
implements Serializable,
Comparable<TeamscaleIssue> {
    private static final long serialVersionUID = 1L;
    public static final String VALUE_SEPARATOR = ",";
    public static final String WORK_ITEM_TYPE_PROPERTY_NAME = "workItemType";
    public static final String ADDITIONAL_FIELD_NAMES_PROPERTY_NAME = "additionalFieldNames";
    public static final String ADDITIONAL_FIELD_VALUES_PROPERTY_NAME = "additionalFieldValues";
    protected static final String ID_PROPERTY_NAME = "id";
    protected static final String SUBJECT_PROPERTY_NAME = "subject";
    protected static final String ASSIGNEE_PROPERTY_NAME = "assignee";
    protected static final String AUTHOR_PROPERTY_NAME = "author";
    protected static final String DESCRIPTION_PROPERTY_NAME = "description";
    protected static final String CREATED_PROPERTY_NAME = "created";
    protected static final String UPDATED_PROPERTY_NAME = "updated";
    protected static final String URL_PROPERTY_NAME = "url";
    protected static final String STATUS_PROPERTY_NAME = "status";
    protected static final String CLOSED_PROPERTY_NAME = "closed";
    protected static final String PARENT_ID_PROPERTY_NAME = "parentId";
    @JsonProperty(value="id")
    private final TeamscaleIssueId id;
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="assignee")
    private String assignee;
    @JsonProperty(value="author")
    private String author;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="created")
    private final long created;
    @JsonProperty(value="updated")
    private long updated;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="additionalFieldNames")
    private final ArrayList<String> additionalFieldNames;
    @JsonProperty(value="additionalFieldValues")
    private final ArrayList<String> additionalFieldValues;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="closed")
    private boolean closed;
    @JsonProperty(value="parentId")
    private @Nullable TeamscaleIssueId parentId;

    public TeamscaleIssue(TeamscaleIssue issue) {
        this.id = issue.id;
        this.subject = issue.subject;
        this.assignee = issue.assignee;
        this.author = issue.author;
        this.description = issue.description;
        this.created = issue.created;
        this.updated = issue.updated;
        this.status = issue.status;
        this.closed = issue.closed;
        this.url = issue.url;
        this.additionalFieldNames = new ArrayList<String>(issue.additionalFieldNames);
        this.additionalFieldValues = new ArrayList<String>(issue.additionalFieldValues);
        this.parentId = issue.parentId;
    }

    @JsonCreator
    protected TeamscaleIssue(@JsonProperty(value="id") TeamscaleIssueId id, @JsonProperty(value="subject") String subject, @JsonProperty(value="assignee") String assignee, @JsonProperty(value="author") String author, @JsonProperty(value="description") String description, @JsonProperty(value="created") long created, @JsonProperty(value="updated") long updated, @JsonProperty(value="status") String status, @JsonProperty(value="closed") boolean closed, @JsonProperty(value="url") String url, @JsonProperty(value="additionalFieldNames") List<String> additionalFieldNames, @JsonProperty(value="additionalFieldValues") List<String> additionalFieldValues, @JsonProperty(value="parentId") @Nullable TeamscaleIssueId parentId) {
        CCSMAssert.isNotNull((Object)id, (String)"An issue's ID must not be null or the empty string");
        this.id = id;
        this.subject = StringUtils.emptyIfNull((String)subject).trim();
        this.assignee = StringUtils.emptyIfNull((String)assignee).trim();
        this.author = StringUtils.emptyIfNull((String)author).trim();
        this.description = StringUtils.emptyIfNull((String)description).trim();
        this.created = created;
        this.updated = updated;
        this.status = StringUtils.emptyIfNull((String)status).trim();
        this.closed = closed;
        this.url = StringUtils.emptyIfNull((String)url).trim();
        CCSMAssert.isTrue((additionalFieldNames.size() == additionalFieldValues.size() ? 1 : 0) != 0, (String)"Lists for names and values of additional fields must have same length");
        this.additionalFieldNames = new ArrayList<String>(additionalFieldNames);
        this.additionalFieldValues = additionalFieldValues.stream().map(value -> value == null ? null : value.trim()).collect(Collectors.toCollection(ArrayList::new));
        this.parentId = parentId;
    }

    public TeamscaleIssue(TeamscaleIssueId id, String subject, String assignee, String author, String description, long created, long updated, String status, boolean closed, String url, List<String> additionalFieldNames, List<String> additionalFieldValues, String parentId) {
        this(id, subject, assignee, author, description, created, updated, status, closed, url, additionalFieldNames, additionalFieldValues, TeamscaleIssue.calculateParentTeamscaleId(id, parentId));
    }

    private static TeamscaleIssueId calculateParentTeamscaleId(TeamscaleIssueId id, String parentId) {
        if (id == null || parentId == null || parentId.isEmpty()) {
            return null;
        }
        return id.withExternalId(parentId);
    }

    public TeamscaleIssue(TeamscaleIssueId id, long created) {
        this(id, created, null, null);
    }

    public TeamscaleIssue(TeamscaleIssueId id, long created, String assignee, String subject) {
        this(id, subject, assignee, null, null, created, created, null, false, null, Collections.emptyList(), Collections.emptyList(), (TeamscaleIssueId)null);
    }

    public TeamscaleIssueId getId() {
        return this.id;
    }

    @JsonIgnore
    @JsonGetter(value="workItemType")
    public EWorkItemType getWorkItemType() {
        return EWorkItemType.ISSUE_ITEM;
    }

    public String getHumanReadableType() {
        return this.getWorkItemType().getHumanReadable();
    }

    @JsonGetter(value="uniformPath")
    public UniformPath getUniformPath() {
        return this.id.computeUniformPath(this.getWorkItemType());
    }

    public Optional<TeamscaleIssueId> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public void setParentId(@Nullable TeamscaleIssueId parentId) {
        this.parentId = parentId;
    }

    public String getIdAsString() {
        return this.getId().toString();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getUrl() {
        return this.url;
    }

    public UnmodifiableList<String> getAdditionalFieldNames() {
        return CollectionUtils.asUnmodifiable(this.additionalFieldNames);
    }

    public UnmodifiableList<String> getAdditionalFieldValues() {
        return CollectionUtils.asUnmodifiable(this.additionalFieldValues);
    }

    public String getAdditionalFieldValue(String fieldName) {
        for (int i = 0; i < this.additionalFieldNames.size(); ++i) {
            if (!fieldName.equalsIgnoreCase(this.additionalFieldNames.get(i))) continue;
            return this.additionalFieldValues.get(i);
        }
        return null;
    }

    public Optional<String> getStringValueByPropertyName(String propertyName) {
        switch (propertyName) {
            case "id": {
                return Optional.of(this.getIdAsString());
            }
            case "subject": {
                return Optional.of(this.subject);
            }
            case "assignee": {
                return Optional.of(this.getAssignee());
            }
            case "author": {
                return Optional.of(this.getAuthor());
            }
            case "description": {
                return Optional.of(this.getDescription());
            }
            case "created": {
                return Optional.of(Long.toString(this.getCreated()));
            }
            case "updated": {
                return Optional.of(Long.toString(this.getUpdated()));
            }
            case "url": {
                return Optional.of(this.getUrl());
            }
            case "status": {
                return Optional.of(this.getStatus());
            }
            case "closed": {
                return Optional.of(Boolean.toString(this.isClosed()));
            }
            case "parentId": {
                return Optional.of(this.getParentId().toString());
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return "Issue [id=" + String.valueOf(this.id) + ", subject=" + this.subject + ", assignee=" + this.assignee + ", author=" + this.author + ", description=" + this.description + ", created=" + this.created + ", updated=" + this.updated + ", url=" + this.url + ", additionalFieldNames=" + String.valueOf(this.additionalFieldNames) + ", additionalFieldValues=" + String.valueOf(this.additionalFieldValues) + ", status=" + this.status + ", closed=" + this.closed + ", parentId=" + String.valueOf(this.parentId) + "]";
    }

    @Override
    public int compareTo(TeamscaleIssue other) {
        return this.id.compareTo(other.id);
    }

    public void setSubject(String subject) {
        this.subject = StringUtils.emptyIfNull((String)subject).trim();
    }

    public void setAssignee(String assignee) {
        this.assignee = StringUtils.emptyIfNull((String)assignee).trim();
    }

    public void setAuthor(String author) {
        this.author = StringUtils.emptyIfNull((String)author).trim();
    }

    public void setDescription(String description) {
        this.description = StringUtils.emptyIfNull((String)description).trim();
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public void setStatus(String status) {
        this.status = StringUtils.emptyIfNull((String)status).trim();
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    protected int findCustomFieldIndex(String name) {
        for (int i = 0; i < this.additionalFieldNames.size(); ++i) {
            if (!this.additionalFieldNames.get(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void setCustomField(String name, String value) {
        int index = this.findCustomFieldIndex(name);
        if (index >= 0) {
            this.additionalFieldValues.set(index, value);
        } else {
            this.additionalFieldNames.add(name);
            this.additionalFieldValues.add(value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamscaleIssue issue = (TeamscaleIssue)o;
        return this.created == issue.created && this.updated == issue.updated && this.closed == issue.closed && Objects.equals(this.id, issue.id) && this.getWorkItemType() == issue.getWorkItemType() && Objects.equals(this.subject, issue.subject) && Objects.equals(this.assignee, issue.assignee) && Objects.equals(this.author, issue.author) && Objects.equals(this.description, issue.description) && Objects.equals(this.url, issue.url) && this.additionalFieldsEqual(issue) && Objects.equals(this.status, issue.status) && Objects.equals(this.parentId, issue.parentId);
    }

    private boolean additionalFieldsEqual(TeamscaleIssue issue) {
        return Objects.equals(this.buildAdditionalFieldsMap(), issue.buildAdditionalFieldsMap());
    }

    protected Map<String, ?> buildAdditionalFieldsMap() {
        return CollectionUtils.zipAsMap(this.additionalFieldNames, this.additionalFieldValues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.getWorkItemType(), this.subject, this.assignee, this.author, this.description, this.created, this.updated, this.url, this.buildAdditionalFieldsMap(), this.status, this.closed, this.parentId});
    }
}

