/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis;

import com.teamscale.core.analysis.IndexDelta;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public interface IIndexDelta
extends Serializable {
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size();

    public List<? extends IIndexDelta> split(int var1);

    public IIndexDelta combine(Collection<? extends IIndexDelta> var1);

    public IndexDelta<String> asLogDelta();

    public static <T extends IIndexDelta> @NonNull T empty(Class<T> deltaType) {
        Method factory = Arrays.stream(deltaType.getDeclaredMethods()).filter(method -> "empty".equals(method.getName())).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isPrivate(method.getModifiers())).filter(method -> method.getParameterCount() == 0).filter(method -> method.getReturnType().equals(deltaType)).findFirst().orElseThrow(() -> new IllegalStateException("Delta type %s has no non-private static factory method 'empty'".formatted(deltaType)));
        try {
            IIndexDelta emptyDelta = (IIndexDelta)deltaType.cast(factory.invoke(null, new Object[0]));
            if (emptyDelta == null) {
                throw new IllegalStateException("Factory method '%s' returned null".formatted(factory));
            }
            if (!emptyDelta.isEmpty()) {
                throw new IllegalStateException("Factory method '%s' returned a non-empty delta".formatted(factory));
            }
            return (T)emptyDelta;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Could not create empty delta for type: " + String.valueOf(deltaType), e);
        }
    }

    public static <T extends IIndexDelta> T combineAll(List<T> deltas) {
        return (T)(switch (deltas.size()) {
            case 0 -> throw new IllegalArgumentException("deltas must not be empty");
            case 1 -> (IIndexDelta)deltas.getFirst();
            default -> {
                IIndexDelta combined;
                yield combined = ((IIndexDelta)deltas.getFirst()).combine(deltas.subList(1, deltas.size()));
            }
        });
    }

    public static <T extends IIndexDelta> BiFunction<T, T, T> combine() {
        return (d1, d2) -> d1.combine(List.of(d2));
    }
}

