/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class RepositoryNeedsRollbackException
extends RepositoryException {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> rollbackTo;
    private final UUID rollbackId;

    public RepositoryNeedsRollbackException(String message, Map<String, Long> rollbackTo) {
        this(message, rollbackTo, null);
    }

    public RepositoryNeedsRollbackException(String message, Throwable cause, Map<String, Long> rollbackTo) {
        this(message, cause, rollbackTo, null);
    }

    public RepositoryNeedsRollbackException(String message, Map<String, Long> rollbackTo, @Nullable UUID rollbackId) {
        super(Objects.requireNonNull(message, "message"));
        this.rollbackTo = Objects.requireNonNull(rollbackTo, "rollbackTo");
        this.rollbackId = Objects.requireNonNullElseGet(rollbackId, UUID::randomUUID);
    }

    public RepositoryNeedsRollbackException(String message, Throwable cause, Map<String, Long> rollbackTo, @Nullable UUID rollbackId) {
        super(Objects.requireNonNull(message, "message"), Objects.requireNonNull(cause, "cause"));
        this.rollbackTo = Objects.requireNonNull(rollbackTo, "rollbackTo");
        this.rollbackId = Objects.requireNonNullElseGet(rollbackId, UUID::randomUUID);
    }

    public List<CommitDescriptor> getRollbackToAsSchedulingHints() {
        return CollectionUtils.map(this.rollbackTo.entrySet(), entry -> new CommitDescriptor((String)entry.getKey(), ((Long)entry.getValue()).longValue()));
    }

    public UUID getRollbackId() {
        return this.rollbackId;
    }
}

