/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.IConnectorDescriptorConsistencyValidator;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentialsOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.GitHubRepositoryConnectorOptionDescriptor;
import com.teamscale.core.index.IndexLayer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class ConnectorUtils {
    private static final Logger LOGGER = LogManager.getLogger(ConnectorUtils.class);
    public static final String CONNECTOR_IDENTIFIER_PARAMETER_NAME = "Connector Identifier";
    public static final String ACCOUNT_IDENTIFIER = "Account";
    public static final String APPLE_A3_OPTION_IDENTIFIER = "Apple A3 Option Identifier";
    public static final String GITHUB_URL_INSTANCE_OPTION_NAME = "GitHub Server URL";
    private static final Map<String, IntFunction<TemporalAmount>> TIME_UNIT_TO_TEMPORAL_AMOUNT = new HashMap<String, IntFunction<TemporalAmount>>(Map.of("second", Duration::ofSeconds, "minute", Duration::ofMinutes, "hour", Duration::ofHours, "day", Period::ofDays, "week", DurationUtils.ONE_WEEK::multipliedBy, "month", Period::ofMonths, "year", Period::ofYears));
    public static final Pattern RELATIVE_DATE_PATTERN = Pattern.compile("\\s*[<>]?\\s*(\\d+)\\s+(" + StringUtils.concat((Iterable)CollectionUtils.sort(TIME_UNIT_TO_TEMPORAL_AMOUNT.keySet()), (String)"|") + ")s?\\s*(ago|before)?\\s*", 2);
    private static final Set<IConnectorDescriptorConsistencyValidator> CONNECTOR_CONSISTENCY_VALIDATORS = new HashSet<IConnectorDescriptorConsistencyValidator>();

    public static ConnectorDescriptorBase loadAndValidateConnector(ConnectorConfiguration connector, ConfigurationInitializationContext context, InternalProjectId projectId, @Nullable Integer connectorIndex) throws ProjectConfigurationException {
        CCSMAssert.isNotNull((Object)projectId);
        ConnectorDescriptorBase connectorDescriptor = ConnectorUtils.loadConnector(connector, context, projectId);
        ConnectorUtils.validateConnector(connectorDescriptor, connectorIndex);
        return connectorDescriptor;
    }

    public static void validateConnector(ConnectorDescriptorBase descriptor, @Nullable Integer connectorIndex) throws ProjectConfigurationException {
        try {
            descriptor.validate();
        }
        catch (ConnectorValidationException e) {
            throw new ProjectConfigurationException(e, connectorIndex);
        }
    }

    public static ConnectorDescriptorBase loadConnector(ConnectorConfiguration connector, ConfigurationInitializationContext context, InternalProjectId projectId) throws ProjectConfigurationException {
        ConnectorDescriptorBase descriptor = ConnectorUtils.createConnectorDescriptor(connector, projectId);
        try {
            ConnectorUtils.applyConnectorOptions(connector, descriptor, context.getGlobalStorageSystem());
        }
        catch (StorageException e) {
            throw new ProjectConfigurationException(e);
        }
        descriptor.init(context);
        return descriptor;
    }

    public static ConnectorDescriptorBase loadIssueTrackerConnectorFromStorage(InternalProjectId projectId, IndexLayer indexLayer, EIssueTracker issueTracker) throws StorageException, ProjectConfigurationException {
        if (projectId == null || indexLayer == null) {
            throw new ProjectConfigurationException("Project id and storage layer reference required in order to load issue tracker connector.");
        }
        GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(null, indexLayer, (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, indexLayer);
        if (projectConfiguration == null) {
            throw new ProjectConfigurationException("Project configuration does not exist for provided project id and storage layer.");
        }
        ConnectorConfiguration connectorConfiguration = null;
        Iterator<ConnectorConfiguration> iterator = projectConfiguration.getConnectorsByType(issueTracker).iterator();
        while (iterator.hasNext()) {
            ConnectorConfiguration availableConnectorConfiguration;
            connectorConfiguration = availableConnectorConfiguration = iterator.next();
        }
        if (connectorConfiguration == null) {
            throw new ProjectConfigurationException("Project does not contain requested issue tracker connector.");
        }
        return ConnectorUtils.loadConnector(connectorConfiguration, context, projectId);
    }

    public static ConnectorDescriptorBase createConnectorDescriptor(ConnectorConfiguration connector, InternalProjectId projectId) throws ProjectConfigurationException {
        ConnectorDescriptorBase descriptor = ConnectorUtils.tryCreateConnectorDescriptor(connector).orElseThrow(() -> new ProjectConfigurationException("No connector of type " + connector.getRawType() + " registered. Please ensure that Teamscale has a valid license including this connector type."));
        if (projectId != null) {
            descriptor.setProjectId(projectId);
        }
        return descriptor;
    }

    public static Optional<ConnectorDescriptorBase> tryCreateConnectorDescriptor(ConnectorConfiguration connector) {
        return Optional.ofNullable(ConfigRegistry.getInstance().createConnectorDescriptor(connector.getRawType()));
    }

    private static void applyConnectorOptions(ConnectorConfiguration connector, ConnectorDescriptorBase descriptor, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException, StorageException {
        for (String optionName : connector.getOptionNames()) {
            ConfigOptionDescriptorBase option = descriptor.getOptionByName(optionName);
            if (option == null) {
                throw new ProjectConfigurationException("Unknown option for connector " + connector.getIdentifier() + ": " + optionName);
            }
            if (option instanceof AccountCredentialsOptionDescriptor) {
                ConnectorUtils.generateAccountCredentialsOption(optionName, connector, (ExternalCredentialsIndex)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class));
            }
            if (option instanceof GitHubRepositoryConnectorOptionDescriptor) {
                ConnectorUtils.generateGitHubRepositoryConnectorUrl(optionName, connector);
            }
            option.setValue(connector.getOptionValue(optionName), CodeScopeAware.DEFAULT_CODE_SCOPE);
        }
    }

    private static void generateGitHubRepositoryConnectorUrl(String optionName, ConnectorConfiguration connector) {
        String url = connector.getOptionValue(optionName);
        if (url == null) {
            return;
        }
        connector.setOptionValue(GITHUB_URL_INSTANCE_OPTION_NAME, url);
    }

    private static void generateAccountCredentialsOption(String optionName, ConnectorConfiguration connector, ExternalCredentialsIndex externalCredentialsIndex) throws ProjectConfigurationException {
        String accountIdentifier = connector.getOptionValue(optionName);
        if (accountIdentifier == null) {
            return;
        }
        try {
            ExternalCredentials externalCredentials = AccountCredentials.createOptionsFromAutoGenerateIdentifier(accountIdentifier, externalCredentialsIndex);
            if (externalCredentials == null) {
                return;
            }
            connector.setOptionValue(ACCOUNT_IDENTIFIER, externalCredentials.credentialsName);
        }
        catch (StorageException e) {
            throw new ProjectConfigurationException("Could not generate account from identifier: " + accountIdentifier, e);
        }
    }

    public static Optional<ZonedDateTime> parseDate(String formattedDate) {
        if (formattedDate.equals("no restriction")) {
            return Optional.of(Instant.EPOCH.atZone(DateTimeUtils.getZone()));
        }
        try {
            return Optional.of(ConnectorUtils.parseDateGetStartOfDay(formattedDate));
        }
        catch (DateTimeParseException e) {
            return Optional.empty();
        }
    }

    private static ZonedDateTime parseDateGetStartOfDay(String formattedDate) throws DateTimeParseException {
        Optional<TemporalAmount> relativeOffset = ConnectorUtils.parseRelativeDateToOffset(formattedDate);
        LocalDate date = relativeOffset.isPresent() ? DateTimeUtils.zonedNow().minus(relativeOffset.get()).toLocalDate() : LocalDate.parse(formattedDate, DateTimeFormatter.ISO_LOCAL_DATE);
        return date.atStartOfDay(DateTimeUtils.getZone()).withEarlierOffsetAtOverlap();
    }

    public static Optional<ZonedDateTime> parseDateGetEndOfDay(String formattedDate) {
        try {
            return Optional.of(ConnectorUtils.parseDateGetStartOfDay(formattedDate).plusDays(1L).minusSeconds(1L));
        }
        catch (DateTimeParseException e) {
            return Optional.empty();
        }
    }

    public static Optional<Long> getTimestampForDate(String date) {
        return ConnectorUtils.getTimestamp(date, ConnectorUtils::parseDate);
    }

    public static Optional<Long> getTimestampForEndDate(String date) {
        return ConnectorUtils.getTimestamp(date, ConnectorUtils::parseDateGetEndOfDay);
    }

    private static Optional<Long> getTimestamp(String date, Function<String, Optional<ZonedDateTime>> dateToTimedDateConverter) {
        if (StringUtils.isEmpty((String)date)) {
            return Optional.empty();
        }
        return dateToTimedDateConverter.apply(date).map(zonedDateTime -> zonedDateTime.toInstant().toEpochMilli());
    }

    public static Optional<TemporalAmount> parseRelativeDateToOffset(String relativeDate) {
        Matcher matcher = RELATIVE_DATE_PATTERN.matcher(relativeDate);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        try {
            int amount = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2).toLowerCase();
            IntFunction<TemporalAmount> temporalAmountFactory = TIME_UNIT_TO_TEMPORAL_AMOUNT.get(unit);
            CCSMAssert.isNotNull(temporalAmountFactory, () -> "Unit " + unit + " seems to be missing from TIME_UNIT_TO_MILLIS table");
            return Optional.of(temporalAmountFactory.apply(amount));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static boolean isRelativeDate(String dateString) {
        return RELATIVE_DATE_PATTERN.matcher(dateString).matches();
    }

    public static String replaceRelativeDate(String date) {
        Optional<TemporalAmount> relativeOffset = ConnectorUtils.parseRelativeDateToOffset(date);
        return relativeOffset.map(temporalAmount -> DateTimeUtils.zonedNow().minus((TemporalAmount)temporalAmount).format(DateTimeFormatter.ISO_LOCAL_DATE)).orElse(date);
    }

    public static List<Pattern> validateAndReturnPatterns(List<String> regexes, String name) throws ConnectorValidationException {
        ArrayList<Pattern> validationResults = new ArrayList<Pattern>(regexes.size());
        for (String regex : regexes) {
            validationResults.add(ConnectorUtils.validateAndReturnPattern(regex, name));
        }
        return validationResults;
    }

    public static Pattern validateAndReturnPattern(String regex, String name) throws ConnectorValidationException {
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new ConnectorValidationException(String.format("Problem parsing \"%s\" pattern '%s': %s", name, regex, e.getMessage()), e);
        }
    }

    public static void validateCapturingGroupInRegexPattern(String regex, String name) throws ConnectorValidationException {
        if (regex == null || regex.isEmpty()) {
            return;
        }
        try {
            Pattern pattern = Pattern.compile(regex);
            if (pattern.matcher("").groupCount() == 0) {
                throw new ConnectorValidationException(name + " must contain at least one capturing group");
            }
        }
        catch (PatternSyntaxException e) {
            throw new ConnectorValidationException("Syntax error in " + name + ": " + e.getMessage(), e);
        }
    }

    public static void validateNamedCapturingGroupInRegexPattern(String regex, String groupName, String fieldName) throws ConnectorValidationException {
        try {
            Pattern pattern = Pattern.compile(regex);
            if (!pattern.pattern().contains("(?<" + groupName + ">")) {
                throw new ConnectorValidationException("Could not find group " + groupName + " in " + fieldName);
            }
        }
        catch (PatternSyntaxException e) {
            throw new ConnectorValidationException("Syntax error in " + fieldName + ": " + e.getMessage(), e);
        }
    }

    public static long validateTimestamp(String timestamp) throws ConnectorValidationException {
        try {
            long resolvedTimestamp = ConnectorUtils.getTimestampForDate(timestamp).orElseGet(() -> Long.parseLong(timestamp));
            return Math.max(resolvedTimestamp, 0L);
        }
        catch (NumberFormatException e) {
            throw new ConnectorValidationException("Start Timestamp is not a valid date or timestamp");
        }
    }

    public static List<ConnectorConfiguration> getRepositoryConnectors(MetaIndex metaIndex, ERepositoryConnector repositoryConnectorType) throws StorageException {
        return ((ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class)).getConnectorsByType(repositoryConnectorType);
    }

    public static List<ConnectorConfiguration> getRepositoryConnectors(MetaIndex metaIndex) throws StorageException {
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class);
        ArrayList<ConnectorConfiguration> connectors = new ArrayList<ConnectorConfiguration>();
        for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
            connectorConfiguration.getRepositoryType().ifPresent(type -> connectors.add(connectorConfiguration));
        }
        return connectors;
    }

    public static List<ConnectorConfiguration> getSourceCodeRepositoryConnectors(ProjectConfiguration projectConfiguration, ConfigurationInitializationContext context) throws StorageException {
        return projectConfiguration.getConnectors().stream().filter(connector -> ConnectorUtils.isSourceCodeRepositoryConnector(projectConfiguration.getInternalId(), connector, context)).toList();
    }

    private static boolean isSourceCodeRepositoryConnector(InternalProjectId projectId, ConnectorConfiguration connector, ConfigurationInitializationContext context) {
        try {
            return ConnectorUtils.loadConnector(connector, context, projectId).getConnectorType() == EConnectorType.SOURCE_CODE_REPOSITORY;
        }
        catch (ProjectConfigurationException e) {
            LOGGER.error("Could not load connector %s.".formatted(connector.getIdentifier()), (Throwable)e);
            return CONNECTOR_IDENTIFIER_PARAMETER_NAME.equals(connector.getIdentifierOptionName());
        }
    }

    public static void validateBranchTransformationTargets(PairList<String, String> branchTransformation, String defaultBranchName) throws ConnectorValidationException {
        if (branchTransformation.extractSecondList().contains(defaultBranchName)) {
            throw new ConnectorValidationException("The provided branch transformation patterns will exclude the set default branch '" + defaultBranchName + "' from the analysis. Please modify the transformation patterns so that there is no target that matches the default branch name or choose another default branch.");
        }
    }

    private static boolean isBranchMatchedByPattern(Pattern pattern, String branchName) {
        return pattern.matcher(branchName).matches();
    }

    public static boolean isBranchMatchedByAnyPattern(String branchName, Collection<Pattern> patterns) {
        return patterns.stream().anyMatch(pattern -> ConnectorUtils.isBranchMatchedByPattern(pattern, branchName));
    }

    public static void registerConnectorConsistencyValidator(IConnectorDescriptorConsistencyValidator connectorConsistencyValidator) {
        CONNECTOR_CONSISTENCY_VALIDATORS.add(connectorConsistencyValidator);
    }

    public static void validateConnectorConsistency(List<ConnectorDescriptorBase> connectors, boolean usesExternalStorageBackend, List<PublicProjectId> projectIds) throws ConnectorValidationException {
        for (IConnectorDescriptorConsistencyValidator connectorConsistencyValidator : CONNECTOR_CONSISTENCY_VALIDATORS) {
            connectorConsistencyValidator.validate(connectors, usesExternalStorageBackend, projectIds);
        }
    }

    public static String concatenateNonEmptyWithSlash(String ... itemsToConcatenate) {
        return ConnectorUtils.concatenateNonEmptyWithSlash(Arrays.asList(itemsToConcatenate));
    }

    private static String concatenateNonEmptyWithSlash(List<String> itemsToConcatenate) {
        if ((itemsToConcatenate = CollectionUtils.filter(itemsToConcatenate, item -> !StringUtils.isEmpty((String)item))).isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < itemsToConcatenate.size() - 1; ++i) {
            String item2 = (String)itemsToConcatenate.get(i);
            if (i > 0) {
                item2 = StringUtils.stripPrefix((String)item2, (String)"/");
            }
            sb.append(StringUtils.ensureEndsWith((String)item2, (String)"/"));
        }
        sb.append(StringUtils.stripPrefix((String)((String)CollectionUtils.getLast((List)itemsToConcatenate)), (String)"/"));
        return sb.toString();
    }

    private ConnectorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

