/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.runtime.impl.analysis.trigger.PrivilegedTrigger;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class TriggerBuilder {
    private final Class<? extends IAnalysisStep> triggerClass;
    private final Map<String, JsonNode> triggerParameters;
    private final Map<ESchedulingParameter, JsonNode> schedulingParameters;
    private final Map<String, String> resolvedIndexByPlaceholder;

    public TriggerBuilder(@NonNull Class<? extends IAnalysisStep> processorClass) {
        this(Objects.requireNonNull(processorClass, "processorClass"), new HashMap<String, JsonNode>(), new EnumMap<ESchedulingParameter, JsonNode>(ESchedulingParameter.class), new HashMap<String, String>());
    }

    public TriggerBuilder(Class<? extends IAnalysisStep> processorClass, ETriggerConcurrency concurrency) {
        this(processorClass);
        this.setSchedulingParameter(ESchedulingParameter.CONCURRENCY, (Object)concurrency);
    }

    private TriggerBuilder(Class<? extends IAnalysisStep> triggerClass, Map<String, JsonNode> triggerParameters, Map<ESchedulingParameter, JsonNode> schedulingParameters, Map<String, String> resolvedIndexByPlaceholder) {
        this.triggerClass = triggerClass;
        this.triggerParameters = triggerParameters;
        this.schedulingParameters = schedulingParameters;
        this.resolvedIndexByPlaceholder = resolvedIndexByPlaceholder;
    }

    public TriggerBuilder setTriggerParameter(String name, ITriggerParameter value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        JsonNode existingValue = this.triggerParameters.putIfAbsent(name, value.toJson());
        if (existingValue != null) {
            throw new IllegalStateException("Duplicate trigger value for parameter '%s'".formatted(name));
        }
        return this;
    }

    public TriggerBuilder setTriggerParameter(String name, String value) {
        return this.setTriggerParameter(name, ITriggerParameter.of(value));
    }

    public TriggerBuilder setTriggerParameter(String name, boolean value) {
        return this.setTriggerParameter(name, ITriggerParameter.of(value));
    }

    public TriggerBuilder setTriggerParameter(String name, int value) {
        return this.setTriggerParameter(name, ITriggerParameter.of(value));
    }

    public TriggerBuilder setTriggerParameter(String name, long value) {
        return this.setTriggerParameter(name, ITriggerParameter.of(value));
    }

    public TriggerBuilder setSchedulingParameter(ESchedulingParameter parameter, Object value) {
        Objects.requireNonNull(parameter, "parameter");
        Objects.requireNonNull(value, "value");
        if (!parameter.getParameterType().isInstance(value)) {
            throw new IllegalArgumentException("Parameter type mismatch: %s. Expected %s but got %s".formatted(parameter.getParameterName(), parameter.getParameterType(), value));
        }
        JsonNode existingValue = this.schedulingParameters.putIfAbsent(parameter, JsonUtils.getObjectMapper().valueToTree(value));
        if (existingValue != null) {
            throw new IllegalStateException("Duplicate trigger value for parameter '%s'".formatted(new Object[]{parameter}));
        }
        return this;
    }

    public TriggerBuilder setCost(ETriggerCost cost) {
        return this.setSchedulingParameter(ESchedulingParameter.COST, (Object)cost);
    }

    public TriggerBuilder resolveIndexNamePlaceholder(String placeholder, String indexName) {
        String oldValue = this.resolvedIndexByPlaceholder.putIfAbsent(placeholder, indexName);
        if (oldValue != null) {
            throw new IllegalStateException("Duplicate resolved placeholder: %s -> %s and %s".formatted(placeholder, oldValue, indexName));
        }
        return this;
    }

    public TriggerDescription toTriggerDescription() {
        return new TriggerDescription(this);
    }

    Class<? extends IAnalysisStep> getTriggerClass() {
        return this.triggerClass;
    }

    Map<String, JsonNode> getTriggerParameters() {
        return this.triggerParameters;
    }

    Map<ESchedulingParameter, JsonNode> getSchedulingParameters() {
        return this.schedulingParameters;
    }

    Map<String, String> getResolvedIndexByPlaceholder() {
        return this.resolvedIndexByPlaceholder;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public String getSimpleTriggerName() {
        return TriggerBuilder.getSimpleTriggerName(this.triggerClass);
    }

    private static String getSimpleTriggerName(String triggerName) {
        return StringUtils.getLastPart((String)triggerName, (char)'.');
    }

    public static String getSimpleTriggerName(Class<?> processorClass) {
        if (processorClass.isAssignableFrom(PrivilegedTrigger.class)) {
            return processorClass.getName();
        }
        return TriggerBuilder.getSimpleTriggerName(processorClass.getName());
    }

    public static String buildTriggerName(String prefix, String triggerName) {
        return StringUtils.surroundWith((String)"-", (String)prefix, (String)triggerName);
    }

    public String buildTriggerName(String prefix) {
        return TriggerBuilder.buildTriggerName(prefix, this.getSimpleTriggerName());
    }

    public void setMetricEnablementParameter(String parameterName, CodeScopeAware<MetricDescriptor> metrics) {
        CodeScopeAware<String> enablementPerCodeScope = metrics.map(metric -> String.valueOf(metric.isMetricEnabled()));
        this.setTriggerParameter(parameterName, enablementPerCodeScope);
    }
}

